/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateServerBlackboardPacket {
    private final BlockPos pos;
    private final byte[][] pixels;

    public UpdateServerBlackboardPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.pixels = new byte[16][16];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = buf.func_179251_a();
        }
    }

    public UpdateServerBlackboardPacket(BlockPos pos, byte[][] pixels) {
        this.pos = pos;
        this.pixels = pixels;
    }

    public static void buffer(UpdateServerBlackboardPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        for (int i = 0; i < message.pixels.length; ++i) {
            buf.func_179250_a(message.pixels[i]);
        }
    }

    public static void handler(UpdateServerBlackboardPacket message, Supplier<NetworkEvent.Context> ctx) {
        World world = Objects.requireNonNull(ctx.get().getSender()).field_70170_p;
        ctx.get().enqueueWork(() -> {
            TileEntity tileentity;
            if (world != null && (tileentity = world.func_175625_s(message.pos)) instanceof BlackboardBlockTile) {
                BlackboardBlockTile board = (BlackboardBlockTile)tileentity;
                world.func_184133_a(null, message.pos, SoundEvents.field_219696_mD, SoundCategory.BLOCKS, 1.0f, 0.8f);
                board.pixels = message.pixels;
                tileentity.func_70296_d();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

