/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.blocks.CeilingBannerBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.FlagBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.HangingSignBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.client.renderers.items.FlagItemRenderer;
import net.mehvahdjukaar.supplementaries.datagen.types.IWoodType;
import net.mehvahdjukaar.supplementaries.datagen.types.WoodTypes;
import net.mehvahdjukaar.supplementaries.items.BurnableBlockItem;
import net.mehvahdjukaar.supplementaries.items.FlagItem;
import net.mehvahdjukaar.supplementaries.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BannerBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Variants {
    public static boolean hasWoodInstalled(IWoodType wood) {
        return ModList.get().isLoaded(wood.getNamespace());
    }

    public static <T extends IForgeRegistryEntry<T>> Map<IWoodType, RegistryObject<T>> makeVariants(DeferredRegister<T> registry, String name, Supplier<T> supplier) {
        HashMap<IWoodType, RegistryObject<T>> map = new HashMap<IWoodType, RegistryObject<T>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String s = name + "_" + wood;
            map.put(wood, registry.register(s, supplier));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Block>> makeHangingSingsBlocks() {
        HashMap<IWoodType, RegistryObject<Block>> map = new HashMap<IWoodType, RegistryObject<Block>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getHangingSignName(wood);
            map.put(wood, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new HangingSignBlock(AbstractBlock.Properties.func_200949_a((Material)wood.getMaterial(), (MaterialColor)wood.getColor()).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a).harvestTool(ToolType.AXE).func_226896_b_().func_200942_a())));
        }
        return map;
    }

    public static Map<IWoodType, RegistryObject<Item>> makeHangingSignsItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getHangingSignName(wood);
            map.put(wood, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new BurnableBlockItem((Block)ModRegistry.HANGING_SIGNS.get(wood).get(), new Item.Properties().func_200916_a(!Variants.hasWoodInstalled(wood) ? null : ModRegistry.getTab(ItemGroup.field_78031_c, "hanging_sign")), 200)));
        }
        return map;
    }

    public static String getHangingSignName(IWoodType type) {
        return "hanging_sign_" + type.getRegName();
    }

    public static Map<IWoodType, RegistryObject<Item>> makeSignPostItems() {
        HashMap<IWoodType, RegistryObject<Item>> map = new HashMap<IWoodType, RegistryObject<Item>>();
        for (IWoodType wood : WoodTypes.TYPES.values()) {
            String name = Variants.getSignPostName(wood);
            map.put(wood, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new SignPostItem(new Item.Properties().func_200916_a(!Variants.hasWoodInstalled(wood) ? null : ModRegistry.getTab(ItemGroup.field_78031_c, "sign_post")), wood)));
        }
        return map;
    }

    public static String getSignPostName(IWoodType type) {
        return "sign_post_" + type.getRegName();
    }

    public static Map<DyeColor, RegistryObject<Block>> makeFlagBlocks(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.func_176762_d();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new FlagBlock(color, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color.func_196055_e()).func_200943_b(1.0f).func_226896_b_().func_200947_a(SoundType.field_185848_a))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makeFlagItems(String baseName) {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.func_176762_d();
            map.put(color, (RegistryObject<Item>)ModRegistry.ITEMS.register(name, () -> new FlagItem((Block)ModRegistry.FLAGS.get(color).get(), new Item.Properties().func_200917_a(16).setISTER(() -> FlagItemRenderer::new).func_200916_a(ModRegistry.getTab(ItemGroup.field_78031_c, "flag")))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makeCeilingBanners(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.func_176762_d();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new CeilingBannerBlock(color, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)color.func_196055_e()).func_200943_b(1.0f).func_200942_a().func_200947_a(SoundType.field_185848_a).lootFrom(() -> BannerBlock.func_196287_a((DyeColor)color)))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makeCeilingBannersItems() {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color, ModRegistry.regBlockItem(ModRegistry.CEILING_BANNERS.get(color), null));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Block>> makePresents(String baseName) {
        HashMap<DyeColor, RegistryObject<Block>> map = new HashMap<DyeColor, RegistryObject<Block>>();
        for (DyeColor color : DyeColor.values()) {
            String name = baseName + "_" + color.func_176762_d();
            map.put(color, (RegistryObject<Block>)ModRegistry.BLOCKS.register(name, () -> new PresentBlock(color, AbstractBlock.Properties.func_200949_a((Material)Material.field_151580_n, (MaterialColor)color.func_196055_e()).func_200943_b(1.0f).func_200947_a(SoundType.field_185854_g))));
        }
        return map;
    }

    public static Map<DyeColor, RegistryObject<Item>> makePresentsItems() {
        HashMap<DyeColor, RegistryObject<Item>> map = new HashMap<DyeColor, RegistryObject<Item>>();
        for (DyeColor color : DyeColor.values()) {
            map.put(color, ModRegistry.regBlockItem(ModRegistry.PRESENTS.get(color), ModRegistry.getTab(ItemGroup.field_78031_c, "present")));
        }
        return map;
    }
}

