/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.utility.TelepadEntry;

public class PacketRemoveTelepadEntry
implements IMessage {
    private UUID playerUUID;
    private TelepadEntry entry;

    public PacketRemoveTelepadEntry(UUID playerUUID, TelepadEntry entry) {
        this.playerUUID = playerUUID;
        this.entry = entry;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entry = new TelepadEntry(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        this.entry.writeToByteBuf(buf);
    }

    public PacketRemoveTelepadEntry() {
    }

    public static class PacketRemoveTelepadEntryHandler
    implements IMessageHandler<PacketRemoveTelepadEntry, IMessage> {
        public IMessage onMessage(PacketRemoveTelepadEntry packet, MessageContext ctx) {
            ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> {
                EntityPlayer player = ctx.getServerHandler().field_147369_b.field_70170_p.func_152378_a(packet.playerUUID);
                TelepadData td = (TelepadData)player.getCapability(TelePadDataCapability.CAPABILITY, null);
                td.removeEntry(packet.entry);
                td.removeEventualQueuedForRemovalEntries();
                td.sync();
            });
            return null;
        }
    }
}

