/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import subaraki.telepads.capability.TelePadDataCapability;
import subaraki.telepads.capability.TelepadData;
import subaraki.telepads.gui.server.ContainerTelepad;
import subaraki.telepads.handler.ConfigurationHandler;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class TileEntityTelepad
extends TileEntity
implements ITickable {
    private int dimension;
    public static final int COLOR_FEET_BASE = new Color(26, 246, 172).getRGB();
    public static final int COLOR_ARROW_BASE = new Color(243, 89, 233).getRGB();
    private int colorFrame = COLOR_FEET_BASE;
    private int colorBase = COLOR_ARROW_BASE;
    private int upgradeRotation = 0;
    private boolean hasDimensionUpgrade = false;
    private boolean hasRedstoneUpgrade = false;
    private boolean isPowered = false;
    private boolean isPublic = false;
    private boolean isStandingOnPlatform;
    private int coordinate_handler_index = -1;
    private AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v()).func_72321_a(1.0, 1.0, 1.0);

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.dimension = compound.func_74762_e("dimension");
        this.hasDimensionUpgrade = compound.func_74767_n("upgrade_dimension");
        this.hasRedstoneUpgrade = compound.func_74767_n("upgrade_redstone");
        this.isPowered = compound.func_74767_n("is_powered");
        this.colorBase = compound.func_74762_e("colorBase");
        this.colorFrame = compound.func_74762_e("colorFrame");
        this.upgradeRotation = compound.func_74762_e("upgradeRotation");
        this.isStandingOnPlatform = compound.func_74767_n("standingon");
        this.coordinate_handler_index = compound.func_74762_e("mod_tp");
        this.isPublic = compound.func_74767_n("public");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("dimension", this.dimension);
        compound.func_74757_a("upgrade_dimension", this.hasDimensionUpgrade);
        compound.func_74757_a("upgrade_redstone", this.hasRedstoneUpgrade);
        compound.func_74757_a("is_powered", this.isPowered);
        compound.func_74768_a("colorBase", this.colorBase);
        compound.func_74768_a("colorFrame", this.colorFrame);
        compound.func_74768_a("upgradeRotation", this.upgradeRotation);
        compound.func_74757_a("standingon", this.isStandingOnPlatform);
        compound.func_74768_a("mod_tp", this.coordinate_handler_index);
        compound.func_74757_a("public", this.isPublic);
        return compound;
    }

    public void func_73660_a() {
        if (this.isPowered) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v());
            List list = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
            if (!list.isEmpty()) {
                this.setPlatform(true);
                for (EntityPlayer standing : list) {
                    TelepadData playersave = (TelepadData)standing.getCapability(TelePadDataCapability.CAPABILITY, null);
                    if (playersave.getCounter() > 0 && !playersave.isInTeleportGui()) {
                        --playersave.counter;
                        continue;
                    }
                    if (playersave.getCounter() != 0 || playersave.isInTeleportGui()) continue;
                    if (this.field_145850_b.field_73011_w.getDimension() == 1 && ConfigurationHandler.instance.allowDragonBlocking) {
                        for (Object o : this.field_145850_b.field_72996_f) {
                            if (!(o instanceof EntityDragon)) continue;
                            playersave.setCounter(playersave.getMaxTime());
                            standing.func_145747_a(new TextComponentTranslation("dragon.obstructs", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE).func_150217_b(Boolean.valueOf(true))));
                            return;
                        }
                    }
                    if (this.getCoordinateHandlerIndex() > -1) {
                        String[] tpl = ConfigurationHandler.instance.tp_locations;
                        int index = this.getCoordinateHandlerIndex();
                        CoordinateHandler coords = new CoordinateHandler(tpl[index]);
                        int dimension = coords.getDimension();
                        if (standing.field_71093_bK != dimension) {
                            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                            WorldServer worldDestination = server.func_71218_a(dimension);
                            BlockPos pos = coords.getPosition((World)worldDestination);
                            Teleport.teleportEntityToDimension((Entity)standing, pos, dimension);
                            continue;
                        }
                        BlockPos pos = coords.getPosition(this.func_145831_w());
                        Teleport.teleportEntityInsideSameDimension((Entity)standing, pos);
                        continue;
                    }
                    playersave.setInTeleportGui(true);
                    playersave.setCounter(playersave.getMaxTime());
                    this.activateTelepadGui(playersave);
                }
            } else {
                this.setPlatform(false);
            }
        }
    }

    public void setPlatform(boolean onPlatform) {
        this.isStandingOnPlatform = onPlatform;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), Telepads.blocks.blockTelepad.func_176223_P(), 3);
    }

    private void activateTelepadGui(TelepadData td) {
        if (!(td.getPlayer().field_71070_bA instanceof ContainerTelepad)) {
            WorldDataHandler.get(this.field_145850_b).syncClient();
            td.removeEventualQueuedForRemovalEntries();
            td.syncPoweredWithWorldData(WorldDataHandler.get(this.field_145850_b));
            td.syncPublicPadsToPlayer(WorldDataHandler.get(this.field_145850_b));
            td.sync();
            td.getPlayer().openGui((Object)Telepads.instance, 0, this.field_145850_b, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimensionID) {
        this.dimension = dimensionID;
    }

    public void setFeetColor(int rgb) {
        this.colorFrame = rgb;
    }

    public void setArrowColor(int rgb) {
        this.colorBase = rgb;
    }

    public int getColorFeet() {
        return this.colorFrame;
    }

    public int getColorArrow() {
        return this.colorBase;
    }

    public boolean hasDimensionUpgrade() {
        return this.hasDimensionUpgrade;
    }

    public void addDimensionUpgrade(boolean allowed) {
        this.upgradeRotation = allowed ? new Random().nextInt(4) : 0;
        this.hasDimensionUpgrade = true;
    }

    public int getUpgradeRotation() {
        return this.upgradeRotation;
    }

    public boolean hasRedstoneUpgrade() {
        return this.hasRedstoneUpgrade;
    }

    public void addRedstoneUpgrade() {
        this.hasRedstoneUpgrade = true;
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setCoordinateHandlerIndex(int index) {
        this.coordinate_handler_index = index;
    }

    public void rotateCoordinateHandlerIndex() {
        ++this.coordinate_handler_index;
        if (this.coordinate_handler_index >= ConfigurationHandler.instance.tp_locations.length) {
            this.coordinate_handler_index = -1;
        }
    }

    public int getCoordinateHandlerIndex() {
        return this.coordinate_handler_index;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public boolean isUsableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean isStandingOnPlatform() {
        return this.isStandingOnPlatform;
    }

    public void toggleAcces() {
        boolean flag = !this.isPublic;
        WorldDataHandler wdh = WorldDataHandler.get(this.func_145831_w());
        TelepadEntry tpe = wdh.getEntryForLocation(this.func_174877_v(), this.getDimension());
        tpe.setPublic(flag);
        this.isPublic = flag;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

