/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.capability.player;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import subaraki.telepads.capability.player.TelePadDataCapability;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketEditWhiteListEntry;
import subaraki.telepads.utility.TelepadEntry;

public class TelepadData {
    private PlayerEntity player;
    private List<TelepadEntry> entries = new ArrayList<TelepadEntry>();
    private LinkedHashMap<String, UUID> whitelist = new LinkedHashMap();
    private boolean isInTeleportGui;
    private static final int MAX_TIME = ConfigData.teleport_seconds * 20;
    public int counter = MAX_TIME;
    private boolean request_teleport = false;

    public void setPlayer(PlayerEntity newPlayer) {
        this.player = newPlayer;
    }

    public static LazyOptional<TelepadData> get(PlayerEntity player) {
        return player.getCapability(TelePadDataCapability.CAPABILITY, null);
    }

    public INBT writeData() {
        CompoundNBT tag = new CompoundNBT();
        ListNBT entryList = new ListNBT();
        if (this.entries != null && !this.entries.isEmpty()) {
            for (TelepadEntry entry : this.entries) {
                if (entry == null) continue;
                entryList.add((Object)entry.writeToNBT(new CompoundNBT()));
            }
        }
        tag.func_218657_a("entries", (INBT)entryList);
        ListNBT friends = new ListNBT();
        this.whitelist.keySet().stream().forEach(name -> {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_186854_a(name, this.whitelist.get(name));
            friends.add((Object)nbt);
        });
        tag.func_218657_a("list", (INBT)friends);
        return tag;
    }

    public void readData(INBT nbt) {
        CompoundNBT tag = (CompoundNBT)nbt;
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        ListNBT entryTagList = tag.func_150295_c("entries", 10);
        for (int tagPos = 0; tagPos < entryTagList.size(); ++tagPos) {
            entryList.add(new TelepadEntry(entryTagList.func_150305_b(tagPos)));
        }
        this.entries = entryList;
        ListNBT friendList = tag.func_150295_c("list", 10);
        friendList.stream().forEach(entry -> ((CompoundNBT)entry).func_150296_c().forEach(key -> this.whitelist.put((String)key, ((CompoundNBT)entry).func_186857_a(key))));
    }

    public List<TelepadEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<TelepadEntry>();
        }
        return this.entries;
    }

    public void addEntry(TelepadEntry entry) {
        if (!this.getEntries().contains(entry)) {
            this.getEntries().add(entry);
        }
    }

    public void removeEntry(TelepadEntry entry) {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.position.equals((Object)entry.position) || tpe.dimensionID != entry.dimensionID) continue;
            this.getEntries().remove(tpe);
            break;
        }
    }

    public boolean isInTeleportGui() {
        return this.isInTeleportGui;
    }

    public void setInTeleportGui(boolean isInTeleportGui) {
        this.isInTeleportGui = isInTeleportGui;
    }

    public void overrideEntries(List<TelepadEntry> entries) {
        this.entries = entries;
    }

    public int getCounter() {
        return this.counter;
    }

    public void countDown() {
        --this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public static int getMaxTime() {
        return MAX_TIME;
    }

    public void removeWhiteListEntryClient(String name) {
        if (this.whitelist.containsKey(name)) {
            this.whitelist.remove(name);
        }
    }

    public void removeWhiteListEntryServer(String name) {
        if (this.whitelist.containsKey(name)) {
            this.whitelist.remove(name);
            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new CPacketEditWhiteListEntry(name, UUID.randomUUID(), false));
        }
    }

    public void addWhiteListEntryServer(ServerPlayerEntity player) {
        GameProfile profile;
        if (!this.isWhiteListFull() && !this.whitelist.containsKey((profile = player.func_146103_bH()).getName())) {
            this.whitelist.put(player.func_146103_bH().getName(), player.func_146103_bH().getId());
            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new CPacketEditWhiteListEntry(profile.getName(), profile.getId(), true));
        }
    }

    public void addWhiteListEntryClient(String name, UUID id) {
        if (!this.isWhiteListFull() && !this.whitelist.containsKey(name)) {
            this.whitelist.put(name, id);
        }
    }

    public void commandWhitelist(String command) {
        if (this.player.field_70170_p.field_72995_K) {
            Telepads.log.error("Tried handling commands on the client side.");
            return;
        }
        MinecraftServer serverWorld = this.player.field_70170_p.func_73046_m();
        if (!command.isEmpty() && command.length() > 2) {
            if ((command = command.toLowerCase()).equals("clear")) {
                this.whitelist.clear();
                return;
            }
            String[] command_split = command.split(" ");
            if (command_split.length == 2) {
                String playername = command_split[1];
                switch (command_split[0]) {
                    case "add": {
                        ServerPlayerEntity player = serverWorld.func_184103_al().func_152612_a(playername);
                        if (player == null) {
                            return;
                        }
                        this.addWhiteListEntryServer(player);
                        break;
                    }
                    case "remove": {
                        this.removeWhiteListEntryServer(playername);
                    }
                }
            }
        }
    }

    public LinkedHashMap<String, UUID> getWhitelist() {
        return this.whitelist;
    }

    public boolean isWhiteListFull() {
        return this.whitelist.size() >= 9;
    }

    public void setRequestTeleportScreen(boolean flag) {
        this.request_teleport = flag;
    }

    public boolean getRequestTeleportScreen() {
        return this.request_teleport;
    }
}

