/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;

public class CoordinateHandler {
    public static final Random rand = new Random();
    public int worldsize = 25000000;
    int xi = 0;
    int zi = 0;
    String yi = "";
    int dim = 0;
    String name = "default";

    public CoordinateHandler(String args) {
        String[] s = args.split("/");
        System.out.println(args);
        this.xi = this.define(s[0]);
        this.yi = s[1];
        this.zi = this.define(s[2]);
        this.defineDim(s[3]);
        this.name = s[4];
    }

    public String getName() {
        return this.name;
    }

    private int define(String definer) {
        if (definer.toLowerCase().equals("random")) {
            int random = rand.nextInt(this.worldsize * 2) - this.worldsize;
            return random;
        }
        if (definer.contains("#")) {
            String[] vals = definer.split("#");
            int min = Integer.valueOf(vals[0]);
            int max = Integer.valueOf(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            int total = 0;
            total = min < 0 && max >= 0 ? max + -1 * min : max + min;
            int result = rand.nextInt(total);
            if (min < 0 && max >= 0) {
                result += min;
            }
            return result;
        }
        return Integer.valueOf(definer);
    }

    private void defineDim(String dimension) {
        if (dimension.toLowerCase().equals("random")) {
            ArrayList list = Lists.newArrayList((Iterable)DimensionType.func_212681_b());
            DimensionType type = (DimensionType)list.get(rand.nextInt(list.size()));
            this.dim = type.func_186068_a();
        } else if (dimension.contains("#")) {
            String[] vals = dimension.split("#");
            int min = Integer.valueOf(vals[0]);
            int max = Integer.valueOf(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            int total = 0;
            total = min < 0 && max >= 0 ? max + -1 * min : max + min;
            this.dim = rand.nextInt(total);
            if (min < 0 && max >= 0) {
                this.dim += min;
            }
        } else {
            this.dim = Integer.valueOf(dimension);
        }
    }

    private int defineY(String definer, World world) {
        if (definer.toLowerCase().equals("random")) {
            world.func_217349_x(new BlockPos(this.xi, 0, this.zi));
            if (world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.xi, this.zi) > 0) {
                System.out.println(world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.xi, this.zi));
                return world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.xi, this.zi);
            }
            return 0;
        }
        if (definer.contains("#")) {
            int counter;
            String[] vals = definer.split("#");
            int min = Integer.valueOf(vals[0]);
            int max = Integer.valueOf(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            BlockPos pos = new BlockPos(this.xi, min, this.zi);
            for (counter = min; counter < max; ++counter) {
                if (world.func_180495_p(pos).func_215686_e((IBlockReader)world, pos) && world.func_175623_d(pos.func_177984_a())) break;
                pos = new BlockPos(this.xi, counter, this.zi);
            }
            int result = counter;
            if (counter >= max) {
                result = min < 0 && max >= 0 ? max + -1 * min : max + min;
                result = result / 2 + min;
            }
            return result;
        }
        return Integer.valueOf(definer);
    }

    public BlockPos getPosition(World world) {
        int y = this.defineY(this.yi, world);
        System.out.println(this.xi + " " + y + " " + this.zi);
        return new BlockPos(this.xi, y, this.zi);
    }

    public int getDimension() {
        return this.dim;
    }
}

