/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import subaraki.telepads.utility.TelepadEntry;

public class WorldDataHandler
extends WorldSavedData {
    private static final String TELEPADS_WORLD_SAVE_DATA = "telepads_world_save_data";
    private List<TelepadEntry> allTelepads = new ArrayList<TelepadEntry>();

    public WorldDataHandler() {
        super(TELEPADS_WORLD_SAVE_DATA);
    }

    public void func_76184_a(CompoundNBT nbt) {
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        ListNBT taglist = nbt.func_150295_c("entries", 10);
        for (int entryTag = 0; entryTag < taglist.size(); ++entryTag) {
            entryList.add(new TelepadEntry(taglist.func_150305_b(entryTag)));
        }
        this.allTelepads = entryList;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        ListNBT taglist = new ListNBT();
        if (!this.allTelepads.isEmpty()) {
            for (TelepadEntry entry : this.allTelepads) {
                taglist.add((Object)entry.writeToNBT(new CompoundNBT()));
            }
        }
        nbt.func_218657_a("entries", (INBT)taglist);
        return nbt;
    }

    public static WorldDataHandler get(IWorld world) {
        ServerWorld overworld = ((ServerWorld)world).func_73046_m().func_71218_a(DimensionType.field_223227_a_);
        return (WorldDataHandler)overworld.func_217481_x().func_215752_a(WorldDataHandler::new, TELEPADS_WORLD_SAVE_DATA);
    }

    public void addEntry(TelepadEntry entry) {
        if (!this.contains(entry)) {
            this.allTelepads.add(entry);
        }
    }

    public boolean contains(TelepadEntry entry) {
        if (this.allTelepads.isEmpty()) {
            return false;
        }
        for (TelepadEntry pad : this.allTelepads) {
            if (!entry.equals(pad)) continue;
            return true;
        }
        return false;
    }

    public void removeEntry(TelepadEntry entry) {
        if (this.contains(entry)) {
            this.allTelepads.remove(entry);
        }
    }

    public TelepadEntry getEntryForLocation(BlockPos pos, int dimensionId) {
        if (this.allTelepads.isEmpty()) {
            return null;
        }
        for (TelepadEntry entry : this.allTelepads) {
            if (!entry.position.equals((Object)pos) || entry.dimensionID != dimensionId) continue;
            return entry;
        }
        return null;
    }

    public void updateEntry(TelepadEntry entry) {
        if (this.contains(entry) && this.getEntryForLocation(entry.position, entry.dimensionID) != null) {
            this.allTelepads.remove(this.getEntryForLocation(entry.position, entry.dimensionID));
            this.allTelepads.add(entry);
        }
    }

    public boolean isEntryPowered(TelepadEntry entry) {
        return this.contains(entry) && this.getEntryForLocation((BlockPos)entry.position, (int)entry.dimensionID).isPowered;
    }

    public List<TelepadEntry> getEntries() {
        return this.allTelepads;
    }

    public void copyOverEntries(List<TelepadEntry> allTelepads) {
        this.allTelepads = allTelepads;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="telepads")
    public static class WorldDataHandlerSaveEvent {
        @SubscribeEvent
        public static void onWorldSave(WorldEvent.Save event) {
            if (event.getWorld() instanceof ServerWorld) {
                ServerWorld server = (ServerWorld)event.getWorld();
                ServerWorld overworld = server.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
                WorldDataHandler.get((IWorld)overworld).func_76185_a();
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load event) {
            if (event.getWorld() instanceof ServerWorld) {
                ServerWorld server = (ServerWorld)event.getWorld();
                ServerWorld overworld = server.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
                WorldDataHandler.get((IWorld)overworld);
            }
        }
    }
}

