/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network.server;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.IPacketBase;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class SPacketTeleport
implements IPacketBase {
    public TelepadEntry goTo;
    public BlockPos oldPos;
    public boolean force;

    public SPacketTeleport(BlockPos playerFrom, TelepadEntry goTo, boolean forceTeleport) {
        this.oldPos = playerFrom;
        this.goTo = goTo;
        this.force = forceTeleport;
    }

    public SPacketTeleport(PacketBuffer buf) {
        this.decode(buf);
    }

    public SPacketTeleport() {
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeLong(this.oldPos.func_218275_a());
        this.goTo.writeToBuffer(buf);
        buf.writeBoolean(this.force);
    }

    @Override
    public void decode(PacketBuffer buf) {
        this.oldPos = BlockPos.func_218283_e((long)buf.readLong());
        this.goTo = new TelepadEntry(buf);
        this.force = buf.readBoolean();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            WorldDataHandler wdh = WorldDataHandler.get((IWorld)player.field_70170_p);
            TelepadData.get((PlayerEntity)player).ifPresent(data -> {
                data.setInTeleportGui(false);
                BlockPos destination = this.goTo.position.func_177984_a();
                int destination_dimension_id = this.goTo.dimensionID;
                int penalty = ConfigData.expConsume;
                if (penalty > 0 && player.field_71068_ca == 0 && player.field_71106_cc * (float)player.func_71050_bK() <= (float)penalty) {
                    player.func_146105_b(new TranslationTextComponent("no.exp", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                    return;
                }
                if (this.goTo.dimensionID == player.field_71093_bK.func_186068_a()) {
                    if (this.force && SPacketTeleport.teleportPenalty((PlayerEntity)player)) {
                        Teleport.teleportEntityInsideSameDimension((Entity)player, destination);
                        return;
                    }
                    if (wdh.contains(this.goTo)) {
                        if (!this.goTo.isPowered) {
                            if (destination_dimension_id == player.field_71093_bK.func_186068_a() && SPacketTeleport.teleportPenalty((PlayerEntity)player)) {
                                Teleport.teleportEntityInsideSameDimension((Entity)player, destination);
                            }
                        } else {
                            player.func_146105_b(new TranslationTextComponent("no.power", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                        }
                    } else {
                        data.setInTeleportGui(true);
                    }
                } else {
                    if (this.force && SPacketTeleport.teleportPenalty((PlayerEntity)player)) {
                        Teleport.teleportEntityToDimension(player, destination, destination_dimension_id);
                        return;
                    }
                    if (wdh.contains(this.goTo)) {
                        if (!this.goTo.isPowered) {
                            if (SPacketTeleport.teleportPenalty((PlayerEntity)player)) {
                                Teleport.teleportEntityToDimension(player, destination, destination_dimension_id);
                            }
                        } else {
                            player.func_146105_b(new TranslationTextComponent("no.power", new Object[0]).func_150255_a(new Style().func_150217_b(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED)), true);
                        }
                    }
                }
            });
        });
        context.get().setPacketHandled(true);
    }

    private static boolean teleportPenalty(PlayerEntity player) {
        int expConsuming = ConfigData.expConsume;
        int lvlConsuming = ConfigData.lvlConsume;
        if (expConsuming == 0 && lvlConsuming == 0) {
            return true;
        }
        if (ConfigData.consumeLvl) {
            if (player.field_71068_ca >= lvlConsuming) {
                player.func_82242_a(-lvlConsuming);
                return true;
            }
            return false;
        }
        float actualExpInBar = player.field_71106_cc * (float)player.func_71050_bK();
        if (actualExpInBar < (float)expConsuming) {
            if (player.field_71068_ca == 0) {
                return false;
            }
            expConsuming = (int)((float)expConsuming - actualExpInBar);
            player.func_82242_a(-1);
            actualExpInBar = player.func_71050_bK();
            float total = actualExpInBar - (float)expConsuming;
            player.field_71106_cc = 0.0f;
            if (total < 0.0f) {
                total = 0.0f;
            }
            player.func_195068_e((int)total);
            return true;
        }
        float total = actualExpInBar - (float)expConsuming;
        player.field_71106_cc = 0.0f;
        player.func_195068_e((int)total);
        return true;
    }

    @Override
    public void register(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketTeleport.class, SPacketTeleport::encode, SPacketTeleport::new, SPacketTeleport::handle);
    }
}

