/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketAddTelepadToWorld;
import subaraki.telepads.utility.TelepadEntry;

public class NameTelepadScreen
extends Screen {
    private TextFieldWidget textField;
    private int field_width = 150;
    private int field_height = 20;
    private int center_x;
    private int center_y;
    private String text_share = new TranslationTextComponent("button.share", new Object[0]).func_150254_d();
    private String text_confirm_share = new TranslationTextComponent("confirm.share", new Object[0]).func_150254_d();
    private String text_negate_share = new TranslationTextComponent("negate.share", new Object[0]).func_150254_d();
    private String enter = new TranslationTextComponent("enter.to.confirm", new Object[0]).func_150254_d();
    private String nameYourPad;
    private boolean share = false;
    String sharing = "";
    private boolean should_show_sharing;
    private BlockPos position;

    public NameTelepadScreen(BlockPos position) {
        super((ITextComponent)new TranslationTextComponent("name.pick.screen", new Object[0]));
        this.position = position;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.center_x = this.width / 2;
        this.center_y = this.height / 2;
        this.initTextField();
        this.nameYourPad = new TranslationTextComponent("name.your.telepad", new Object[0]).func_150254_d() + " : " + this.textField.func_146179_b();
        this.initButtons();
    }

    private void initButtons() {
        TelepadData.get((PlayerEntity)this.minecraft.field_71439_g).ifPresent(data -> {
            if (!data.getWhitelist().isEmpty()) {
                this.should_show_sharing = true;
                this.addButton((Widget)new Button(this.center_x - 40, this.center_y + 20, 45, 20, this.text_share, Button2 -> {
                    this.share = !this.share;
                }));
            }
        });
    }

    private void initTextField() {
        this.textField = new TextFieldWidget(this.font, this.center_x - this.field_width / 2, this.center_y - 50, this.field_width, this.field_height, "field_name");
        this.textField.func_146185_a(true);
        this.textField.func_146184_c(true);
        this.textField.func_146205_d(false);
        this.textField.func_146195_b(true);
        String biome_name = this.minecraft.field_71441_e.func_180494_b(this.minecraft.field_71439_g.func_180425_c()).func_205403_k().func_150254_d();
        String format_name = biome_name.substring(0, Math.min(15, biome_name.length()));
        this.textField.func_146180_a(format_name);
        this.textField.func_146203_f(16);
    }

    public void render(int mouseX, int mouseY, float p_render_3_) {
        this.renderBackground();
        super.render(mouseX, mouseY, p_render_3_);
        this.textField.render(mouseX, mouseY, p_render_3_);
        if (this.should_show_sharing) {
            this.sharing = this.share ? this.text_confirm_share : this.text_negate_share;
        }
        this.font.func_175063_a(this.sharing, (float)(this.center_x - this.font.func_78256_a(this.sharing) / 2 + 30), (float)(this.center_y + 27), 0xAFAFAF);
        this.font.func_175063_a(this.enter, (float)(this.center_x - this.font.func_78256_a(this.enter) / 2), (float)this.center_y, 0xFFFFFF);
        this.font.func_175063_a(this.nameYourPad, (float)(this.center_x - this.font.func_78256_a(this.nameYourPad) / 2), (float)(this.center_y - this.field_height), 0xFF0000);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        this.textField.keyPressed(keyCode, scanCode, p_keyPressed_3_);
        if (keyCode == 257 || keyCode == 335 || keyCode == 256) {
            TelepadData.get((PlayerEntity)this.minecraft.field_71439_g).ifPresent(data -> {
                TelepadEntry telepad_entry = new TelepadEntry(this.textField.func_146179_b(), this.minecraft.field_71441_e.field_73011_w.func_186058_p().func_186068_a(), this.position);
                telepad_entry.addUser(this.minecraft.field_71439_g.func_110124_au());
                if (this.share) {
                    data.getWhitelist().values().forEach(entry -> telepad_entry.addUser((UUID)entry));
                }
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketAddTelepadToWorld(telepad_entry));
            });
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean charTyped(char car, int index) {
        this.textField.charTyped(car, index);
        return super.charTyped(car, index);
    }
}

