/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import org.lwjgl.opengl.GL11;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketTeleport;
import subaraki.telepads.tileentity.render.RenderEndPortalFrame;
import subaraki.telepads.utility.ClientReferences;
import subaraki.telepads.utility.TelepadEntry;

public class TeleportScreen
extends Screen {
    private LinkedList<TelepadEntry> entries = new LinkedList();
    private int lookup_dim_id = 0;
    private RenderEndPortalFrame endPortalFrame;
    private int scrollbarscroll = 0;
    TextFieldWidget dimension_indicator;
    protected final List<Widget> unscrollables = Lists.newArrayList();
    protected List<Integer> dimensions_visited = Lists.newArrayList();
    private final boolean is_transmitter_pad;
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private int tuner_counter = 0;

    public TeleportScreen(boolean is_transmitter_pad) {
        super((ITextComponent)new TranslationTextComponent("telepad.gui", new Object[0]));
        this.is_transmitter_pad = is_transmitter_pad;
        this.endPortalFrame = new RenderEndPortalFrame();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        this.lookup_dim_id = this.minecraft.field_71441_e.field_73011_w.func_186058_p().func_186068_a();
        this.scrollbarscroll = 0;
        this.dimension_indicator = new TextFieldWidget(this.font, this.minecraft.field_195558_d.func_198107_o() / 2 - 75, 5, 150, 20, "indicator");
        this.dimension_indicator.func_146180_a(DimensionType.func_186069_a((int)this.lookup_dim_id).getRegistryName().func_110623_a());
        this.initialize_pages();
    }

    public void render(int mouseX, int mouseY, float p_render_3_) {
        this.endPortalFrame.renderEndPortalSurfaceGUI(0.0, 0.0, 0.0, this.minecraft, this);
        GlStateManager.disableLighting();
        TeleportScreen.fill((int)10, (int)30, (int)(this.width - 10), (int)(this.height - 30), (int)0x55444444);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MainWindow window = this.minecraft.field_195558_d;
        int scale = (int)window.func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(10 * scale), (int)(30 * scale), (int)(this.width * scale), (int)((this.height - 60) * scale));
        super.render(mouseX, mouseY, p_render_3_);
        GL11.glDisable((int)3089);
        if (!this.buttons.isEmpty()) {
            this.drawFakeScrollBar();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.dimension_indicator.render(mouseX, mouseY, p_render_3_);
        this.unscrollables.forEach(b -> b.render(mouseX, mouseY, p_render_3_));
        GlStateManager.enableLighting();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseScroll) {
        int index = this.buttons.size() > 0 ? this.buttons.size() - 1 : 0;
        Widget last = (Widget)this.buttons.get(index);
        Widget first = (Widget)this.buttons.get(0);
        int forsee_bottom_limit = (int)((double)(last.y + last.getHeight()) + mouseScroll * 16.0);
        int bottom_limit = this.height - 30 - last.getHeight();
        int forsee_top_limit = (int)((double)(first.y - 15) + mouseScroll * 16.0);
        int top_limit = 35;
        if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.mouseScrolled(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
            return super.mouseScrolled(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.mouseScrolled(mouseX, mouseY, mouseScroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        return super.mouseDragged(mouseX, mouseY, buttonID, amountX, amountY);
    }

    public void onClose() {
        super.onClose();
    }

    private void drawFakeScrollBar() {
        int top = ((Widget)this.buttons.get((int)0)).y;
        float containerSize = this.height - 60;
        int bot = ((Widget)this.buttons.get((int)(this.buttons.size() - 1))).y + ((Widget)this.buttons.get(this.buttons.size() - 1)).getHeight();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
            this.fillGradient(this.width - 10, 30, this.width, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.fillGradient(this.width - 10, 30 + (int)relativeScroll, this.width, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget button : this.buttons) {
            button.y = (int)((double)button.y + scroll * 16.0);
        }
    }

    private void setup_dimension_page() {
        int max_collumns;
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        TelepadData.get((PlayerEntity)player).ifPresent(data -> {
            for (TelepadEntry entry : data.getEntries()) {
                if (entry.dimensionID != this.lookup_dim_id) continue;
                this.entries.add(entry);
            }
        });
        int increment = max_collumns = this.minecraft.field_195558_d.func_198107_o() / 130;
        int central_offset = this.minecraft.field_195558_d.func_198107_o() / 2 - max_collumns * 120 / 2;
        for (TelepadEntry entry : this.entries) {
            int extra_y = increment / max_collumns;
            int extra_x = increment % max_collumns;
            ChatFormatting info = entry.isMissingFromLocation ? ChatFormatting.GRAY : (entry.isPowered ? ChatFormatting.DARK_RED : (entry.hasTransmitter ? ChatFormatting.GREEN : (entry.isPublic ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.WHITE)));
            this.addButton((Widget)new Button(central_offset + 5 + extra_x * 120, 15 + extra_y * 25, 110, 20, info + entry.entryName, button -> {
                if (entry.isMissingFromLocation) {
                    this.onClose();
                    ClientReferences.openMissingScreen(entry);
                } else {
                    NetworkHandler.NETWORK.sendToServer((Object)new SPacketTeleport(this.minecraft.field_71439_g.func_180425_c(), entry, false));
                    this.onClose();
                }
            }));
            ++increment;
        }
    }

    private void add_paging_buttons() {
        while (this.dimensions_visited.get(this.tuner_counter) != this.lookup_dim_id) {
            ++this.tuner_counter;
        }
        int centerx = this.minecraft.field_195558_d.func_198107_o() / 2;
        Button button_left = new Button(centerx - 75 - 25, 5, 20, 20, "<", button -> {
            if (this.dimensions_visited.size() > 1) {
                --this.tuner_counter;
                if (this.tuner_counter < 0) {
                    this.tuner_counter = this.dimensions_visited.size() - 1;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.func_146180_a(DimensionType.func_186069_a((int)this.lookup_dim_id).getRegistryName().func_110623_a());
            this.initialize_pages();
        });
        Button button_right = new Button(centerx + 75 + 5, 5, 20, 20, ">", button -> {
            if (this.dimensions_visited.size() > 1) {
                ++this.tuner_counter;
                if (this.tuner_counter >= this.dimensions_visited.size()) {
                    this.tuner_counter = 0;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.func_146180_a(DimensionType.func_186069_a((int)this.lookup_dim_id).getRegistryName().func_110623_a());
            this.initialize_pages();
        });
        this.unscrollables.add((Widget)button_left);
        this.unscrollables.add((Widget)button_right);
        this.children.add(button_left);
        this.children.add(button_right);
    }

    private void initialize_pages() {
        this.buttons.clear();
        this.children.clear();
        this.entries.clear();
        this.unscrollables.clear();
        this.dimensions_visited.clear();
        this.setup_dimension_list();
        this.setup_dimension_page();
        if (this.is_transmitter_pad) {
            this.add_paging_buttons();
        }
    }

    private void setup_dimension_list() {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        TelepadData.get((PlayerEntity)player).ifPresent(data -> data.getEntries().forEach(entry -> {
            if (!this.dimensions_visited.contains(entry.dimensionID)) {
                this.dimensions_visited.add(entry.dimensionID);
            }
        }));
    }
}

