/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketAddWhiteListEntry;

public class WhiteListScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("telepads", "textures/gui/whitelist.png");
    private final int tex_x = 142;
    private final int tex_y = 166;
    private int center_x;
    private int center_y;
    private boolean is_open = false;
    private final String suggestion = new TranslationTextComponent("suggest.name", new Object[0]).func_150254_d();
    TextFieldWidget textfield;

    public WhiteListScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.whitelist", new Object[0]));
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.minecraft.field_71446_o.func_110577_a(BACKGROUND);
        this.blit(this.center_x - 71, this.center_y - 83, 0, 0, 142, 166);
        if (!this.textfield.func_146179_b().isEmpty()) {
            this.textfield.func_195612_c("");
        } else {
            this.textfield.func_195612_c(this.suggestion);
        }
        super.render(p_render_1_, p_render_2_, p_render_3_);
        for (int i = 0; i < 9; ++i) {
            this.font.func_175063_a("-", (float)(this.center_x - 62), (float)(this.center_y - 47 + i * 13), 0x888888);
        }
        TelepadData.get((PlayerEntity)this.minecraft.field_71439_g).ifPresent(data -> {
            if (!data.getWhitelist().isEmpty()) {
                int index = 0;
                for (String name : data.getWhitelist().keySet()) {
                    this.font.func_175063_a(name, (float)(this.center_x - 54), (float)(this.center_y - 48 + index++ * 10), 0xEEEEEE);
                }
            }
            this.font.func_175063_a(data.getWhitelist().size() + "/9", (float)(this.center_x + 45), (float)(this.center_y - 50), 8738);
            this.font.func_175063_a("<add,remove>[playername]", (float)(this.center_x - 65), (float)(this.center_y + 69), 0x555555);
        });
    }

    public boolean charTyped(char keyCode, int scanCode) {
        if (this.is_open) {
            this.textfield.charTyped(keyCode, scanCode);
            return true;
        }
        this.is_open = true;
        return super.charTyped(keyCode, scanCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (keyCode == 257 || keyCode == 335) {
            String command = this.textfield.func_146179_b();
            this.textfield.func_146180_a("");
            NetworkHandler.NETWORK.sendToServer((Object)new SPacketAddWhiteListEntry(command));
            return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
        }
        if (this.is_open && !super.keyPressed(keyCode, scanCode, p_keyPressed_3_)) {
            this.textfield.keyPressed(keyCode, scanCode, p_keyPressed_3_);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, p_keyPressed_3_);
    }

    protected void init() {
        super.init();
        this.center_x = this.minecraft.field_195558_d.func_198107_o() / 2;
        this.center_y = this.minecraft.field_195558_d.func_198087_p() / 2;
        this.textfield = new TextFieldWidget(this.font, this.center_x - 71 + 5, this.center_y - 83 + 13, 132, 11, "field_name");
        this.textfield.func_195612_c(this.suggestion);
        this.textfield.func_146203_f(23);
        this.textfield.func_146195_b(true);
        this.textfield.func_146184_c(true);
        this.addButton((Widget)this.textfield);
    }
}

