/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.tileentity.render.ModelTelepad;
import subaraki.telepads.tileentity.render.RenderEndPortalFrame;

public class TileEntityTelepadRenderer
extends TileEntityRenderer<TileEntityTelepad> {
    private static final ModelTelepad modeltelepad = new ModelTelepad();
    private static String resourcePath = "telepads:textures/entity/tile/";
    private static ResourceLocation base = new ResourceLocation(resourcePath + "telepad_base.png");
    private static ResourceLocation pads = new ResourceLocation(resourcePath + "telepad_pads.png");
    private static ResourceLocation frame = new ResourceLocation(resourcePath + "telepad_frame.png");
    private static ResourceLocation frame_upgrade = new ResourceLocation(resourcePath + "telepad_dimension_upgrade.png");
    private static ResourceLocation frame_upgrade_2 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_2.png");
    private static ResourceLocation frame_upgrade_3 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_3.png");
    private static ResourceLocation frame_upgrade_4 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_4.png");
    private static int animation_counter;
    private RenderEndPortalFrame endPortalFrame = new RenderEndPortalFrame();

    public void render(TileEntityTelepad te, double x, double y, double z, float partialTicks, int destroyStage) {
        ++animation_counter;
        if (te == null) {
            return;
        }
        TileEntityTelepad tet = null;
        if (te instanceof TileEntityTelepad) {
            tet = te;
        }
        if (tet == null) {
            return;
        }
        if (!tet.hasRedstoneUpgrade() || tet.hasRedstoneUpgrade() && !tet.isPowered()) {
            GlStateManager.pushMatrix();
            this.endPortalFrame.renderEndPortalSurface(x, y - (double)0.56f, z, this.field_147501_a);
            GlStateManager.popMatrix();
        }
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)y + 2.25f), (float)((float)z + 0.5f));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Color colorBase = new Color(tet.getColorArrow());
        Color colorFrame = new Color(tet.getColorFeet());
        this.renderPad(te, colorFrame, colorBase, x, y, z, partialTicks);
        if (tet.hasDimensionUpgrade()) {
            GlStateManager.pushMatrix();
            if (animation_counter < 25) {
                this.func_147499_a(frame_upgrade);
            } else if (animation_counter < 50) {
                this.func_147499_a(frame_upgrade_2);
            } else if (animation_counter < 75) {
                this.func_147499_a(frame_upgrade_3);
            } else if (animation_counter < 99) {
                this.func_147499_a(frame_upgrade_4);
            } else {
                animation_counter = 0;
                this.func_147499_a(frame_upgrade_4);
            }
            GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.scalef((float)0.75f, (float)0.75f, (float)0.75f);
            GlStateManager.translatef((float)-0.1f, (float)0.45f, (float)0.1f);
            switch (tet.getUpgradeRotation()) {
                case 0: {
                    GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 1: {
                    GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)-0.1f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)-0.2f, (float)0.0f, (float)0.2f);
                    break;
                }
                case 3: {
                    GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.2f);
                    break;
                }
                default: {
                    GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)0.2f);
                }
            }
            modeltelepad.renderUpgrade(0.0625f);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        if (tet.hasRedstoneUpgrade()) {
            this.renderTorch(tet, -0.5, 0.4, -0.5, x, y, z);
            this.renderTorch(tet, 0.5, 0.4, -0.5, x, y, z);
            this.renderTorch(tet, -0.5, 0.4, 0.5, x, y, z);
            this.renderTorch(tet, 0.5, 0.4, 0.5, x, y, z);
        }
    }

    private void renderTorch(TileEntityTelepad te, double offsetX, double offsetY, double offsetZ, double x, double y, double z) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        this.func_147499_a(AtlasTexture.field_110575_b);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferbuilder.func_178969_c(x - (double)te.func_174877_v().func_177958_n() - offsetX, y - (double)te.func_174877_v().func_177956_o() - offsetY, z - (double)te.func_174877_v().func_177952_p() - offsetZ);
        World world = this.func_178459_a();
        BlockState state = (BlockState)Blocks.field_150429_aA.func_176223_P().func_206870_a((IProperty)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(te.isPowered()));
        IBakedModel model = blockrendererdispatcher.func_184389_a(state);
        blockrendererdispatcher.func_175019_b().renderModel((IEnviromentBlockReader)world, model, state, te.func_174877_v(), bufferbuilder, false, world.field_73012_v, 0L, null);
        bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public void renderPad(TileEntity tileentity, Color colorFrame, Color colorBase, double x, double y, double z, float f) {
        float f2 = 1.5f;
        GlStateManager.scalef((float)f2, (float)f2, (float)f2);
        GlStateManager.pushMatrix();
        this.func_147499_a(base);
        GlStateManager.color3f((float)((float)colorBase.getRed() / 255.0f), (float)((float)colorBase.getGreen() / 255.0f), (float)((float)colorBase.getBlue() / 255.0f));
        modeltelepad.renderArrows(0.0625f);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.func_147499_a(pads);
        GlStateManager.color3f((float)((float)colorFrame.getRed() / 255.0f), (float)((float)colorFrame.getGreen() / 255.0f), (float)((float)colorFrame.getBlue() / 255.0f));
        modeltelepad.renderLegs(0.0625f);
        GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        modeltelepad.renderLegs(0.0625f);
        GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        this.func_147499_a(frame);
        GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        modeltelepad.renderFrame(0.0625f);
        GlStateManager.popMatrix();
    }
}

