/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.client.CPacketEditWhiteListEntry;
import subaraki.telepads.network.client.CPacketRequestTeleportScreen;
import subaraki.telepads.screen.MissingEntryScreen;
import subaraki.telepads.screen.NameTelepadScreen;
import subaraki.telepads.screen.TeleportScreen;
import subaraki.telepads.utility.TelepadEntry;

public class ClientReferences {
    public static PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void openNamingScreen(BlockPos pos) {
        Minecraft.func_71410_x().func_147108_a((Screen)new NameTelepadScreen(pos));
    }

    public static void openMissingScreen(TelepadEntry entry) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MissingEntryScreen(entry));
    }

    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static void displayScreen(Screen screen) {
        Minecraft.func_71410_x().func_147108_a(screen);
    }

    public static void displayTeleportScreen(boolean has_transmitter) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TeleportScreen(has_transmitter));
    }

    public static void handlePacket(CPacketRequestTeleportScreen packet) {
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
            data.getEntries().clear();
            if (packet.entries != null && !packet.entries.isEmpty()) {
                packet.entries.stream().forEach(entry -> data.getEntries().add((TelepadEntry)entry));
            }
            data.setCounter(TelepadData.getMaxTime());
            data.setInTeleportGui(false);
            if (!data.getEntries().isEmpty()) {
                ClientReferences.displayTeleportScreen(packet.has_transmitter);
            }
        });
    }

    public static void handlePacket(CPacketEditWhiteListEntry packet) {
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
            if (packet.add) {
                data.addWhiteListEntryClient(packet.name, packet.id);
            } else {
                data.removeWhiteListEntryClient(packet.name);
            }
        });
    }
}

