/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;

public class TelepadEntry {
    public String entryName;
    public int dimensionID;
    public BlockPos position;
    public boolean isPowered;
    public boolean hasTransmitter;
    public boolean isPublic;
    public boolean isMissingFromLocation = false;
    private ArrayList<UUID> users = Lists.newArrayList();

    public TelepadEntry(PacketBuffer buf) {
        this(buf.func_150789_c(256), buf.readInt(), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        this.addDetails(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
        int size = buf.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.addUser(buf.func_179253_g());
            }
        }
    }

    public TelepadEntry(CompoundNBT tag) {
        this(tag.func_74779_i("entryName"), tag.func_74762_e("dimensionID"), new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        this.addDetails(tag.func_74767_n("power"), tag.func_74767_n("transmitter"), tag.func_74767_n("public"), tag.func_74767_n("missing"));
        int size = tag.func_74762_e("size");
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.users.add(UUID.fromString(tag.func_74779_i("id_" + i)));
            }
        }
    }

    public TelepadEntry(String name, int dimension, BlockPos pos) {
        this.entryName = name;
        this.dimensionID = dimension;
        this.position = pos;
    }

    private TelepadEntry addDetails(boolean isPowered, boolean hasTransmitter, boolean isPublic, boolean isMissing) {
        this.isPowered = isPowered;
        this.hasTransmitter = hasTransmitter;
        this.isPublic = isPublic;
        this.isMissingFromLocation = isMissing;
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT tag) {
        tag.func_74778_a("entryName", this.entryName);
        tag.func_74768_a("dimensionID", this.dimensionID);
        tag.func_74757_a("power", this.isPowered);
        tag.func_74757_a("transmitter", this.hasTransmitter);
        tag.func_74757_a("public", this.isPublic);
        tag.func_74768_a("x", this.position.func_177958_n());
        tag.func_74768_a("y", this.position.func_177956_o());
        tag.func_74768_a("z", this.position.func_177952_p());
        tag.func_74757_a("missing", this.isMissingFromLocation);
        tag.func_74768_a("size", this.users.size());
        if (this.users.size() > 0) {
            for (int i = 0; i < this.users.size(); ++i) {
                tag.func_74778_a("id_" + i, this.users.get(i).toString());
            }
        }
        return tag;
    }

    public void writeToBuffer(PacketBuffer buf) {
        buf.func_180714_a(this.entryName);
        buf.writeInt(this.dimensionID);
        buf.writeInt(this.position.func_177958_n());
        buf.writeInt(this.position.func_177956_o());
        buf.writeInt(this.position.func_177952_p());
        buf.writeBoolean(this.isPowered);
        buf.writeBoolean(this.hasTransmitter);
        buf.writeBoolean(this.isPublic);
        buf.writeBoolean(this.isMissingFromLocation);
        buf.writeInt(this.users.size());
        if (!this.users.isEmpty()) {
            this.users.stream().forEach(entry -> buf.func_179252_a(entry));
        }
    }

    public String toString() {
        return "Entry Name: " + this.entryName + " DimensionID: " + this.dimensionID + " " + this.position.toString() + " Public Pad:" + this.isPublic + " transmitter: " + this.hasTransmitter + " is powered: " + this.isPowered + " is missing: " + this.isMissingFromLocation;
    }

    public boolean equals(Object compared) {
        if (!(compared instanceof TelepadEntry)) {
            return false;
        }
        TelepadEntry entry = (TelepadEntry)compared;
        return this.entryName.equals(entry.entryName) && this.dimensionID == entry.dimensionID && this.position.equals((Object)entry.position);
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public void setTransmitter(boolean flag) {
        this.hasTransmitter = flag;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean canUse(UUID player_id) {
        return this.isPublic ? true : this.users.contains(player_id);
    }

    public TelepadEntry addUser(UUID player_id) {
        this.users.add(player_id);
        return this;
    }

    public void removeUser(UUID player_id) {
        this.users.remove(player_id);
    }
}

