/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.PacketDistributor;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketRequestNamingScreen;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class BlockTelepad
extends Block
implements IWaterLoggable {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final VoxelShape VOX = VoxelShapes.func_197881_a((AxisAlignedBB)AABB);
    private static final VoxelShape shape = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0));
    private static final VoxelShape shape_n = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.32, 0.0, -0.22, 0.68, 0.15, 0.0));
    private static final VoxelShape shape_s = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.32, 0.0, 1.0, 0.68, 0.15, 1.22));
    private static final VoxelShape shape_e = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.32, 1.22, 0.15, 0.68));
    private static final VoxelShape shape_w = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.32, -0.22, 0.15, 0.68));
    private static final VoxelShape SHAPE_VOX = VoxelShapes.func_216384_a((VoxelShape)shape_w, (VoxelShape[])new VoxelShape[]{shape_e, shape_s, shape_n, shape});
    private static AbstractBlock.Properties block_properties = AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200948_a(5.0f, Float.MAX_VALUE).func_200947_a(SoundType.field_185853_f).harvestTool(ToolType.PICKAXE).harvestLevel(1).func_226896_b_();
    private TranslationTextComponent text_public_rod;
    private TranslationTextComponent text_public_rod_private;
    private TranslationTextComponent text_public_rod_public;
    private TranslationTextComponent text__cycle_rod_normal;
    private TranslationTextComponent text__cycle_rod;
    private TranslationTextComponent cycle_add_success;
    private TranslationTextComponent cycle_add_remove;
    private TranslationTextComponent cycle_add_fail;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public BlockTelepad() {
        super(block_properties);
        this.setRegistryName("telepads", "telepad");
        this.text_public_rod = new TranslationTextComponent("block.info.rod");
        this.text_public_rod_private = new TranslationTextComponent("block.info.rod.private");
        this.text_public_rod_public = new TranslationTextComponent("block.info.rod.public");
        this.text__cycle_rod_normal = new TranslationTextComponent("block.info.cycle.normal");
        this.text__cycle_rod = new TranslationTextComponent("block.info.cycle");
        this.cycle_add_success = new TranslationTextComponent("block.info.add.succes");
        this.cycle_add_remove = new TranslationTextComponent("block.info.add.fail");
        this.cycle_add_fail = new TranslationTextComponent("block.info.add.remove");
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return stateIn;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE_VOX;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VOX;
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return SHAPE_VOX;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public int func_200011_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityTelepad();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TelepadEntry entry;
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.func_201670_d()) {
            return ActionResultType.FAIL;
        }
        if (!heldItem.func_190926_b()) {
            Item item = heldItem.func_77973_b();
            TileEntity tile_entity = world.func_175625_s(pos);
            if (tile_entity instanceof TileEntityTelepad) {
                TileEntityTelepad telepad_tile_entity = (TileEntityTelepad)tile_entity;
                TelepadEntry entry2 = WorldDataHandler.get((IWorld)world).getEntryForLocation(pos, (RegistryKey<World>)world.func_234923_W_());
                if (item.equals(Telepads.ObjectHolders.TRANSMITTER) && !entry2.hasTransmitter) {
                    telepad_tile_entity.addDimensionUpgrade(true);
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    entry2.hasTransmitter = true;
                    heldItem.func_190918_g(player.func_184812_l_() ? 0 : 1);
                    WorldDataHandler.get((IWorld)world).updateEntry(entry2);
                }
                if (item.equals(Telepads.ObjectHolders.TOGGLER) && !telepad_tile_entity.hasRedstoneUpgrade()) {
                    telepad_tile_entity.addRedstoneUpgrade();
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    this.func_220069_a(state, world, pos, state.func_177230_c(), null, false);
                    heldItem.func_190918_g(player.func_184812_l_() ? 0 : 1);
                }
                if (item.equals(Telepads.ObjectHolders.CREATIVE_ROD_PUBLIC)) {
                    telepad_tile_entity.toggleAcces();
                    world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                    entry2.setPublic(telepad_tile_entity.isPublic());
                    IFormattableTextComponent private_rod = this.text_public_rod.func_230532_e_().func_240702_b_(" ").func_230529_a_((ITextComponent)this.text_public_rod_private);
                    IFormattableTextComponent public_rod = this.text_public_rod.func_230532_e_().func_240702_b_(" ").func_230529_a_((ITextComponent)this.text_public_rod_public);
                    IFormattableTextComponent text = telepad_tile_entity.isPublic() ? public_rod : private_rod;
                    player.func_145747_a((ITextComponent)text, player.func_110124_au());
                    WorldDataHandler.get((IWorld)world).updateEntry(entry2);
                }
                if (item.equals(Telepads.ObjectHolders.CREATIVE_ROD)) {
                    telepad_tile_entity.rotateCoordinateHandlerIndex();
                    int index = telepad_tile_entity.getCoordinateHandlerIndex();
                    if (index > -1) {
                        String[] tpl = ConfigData.tp_locations;
                        CoordinateHandler ch = new CoordinateHandler((ServerWorld)world, tpl[index]);
                        String name = ch.getName();
                        IFormattableTextComponent msg = this.text__cycle_rod.func_230532_e_().func_240702_b_(name);
                        player.func_145747_a((ITextComponent)msg, player.func_110124_au());
                        world.func_184138_a(pos, world.func_180495_p(pos), this.func_176223_P(), 3);
                        this.func_220069_a(state, world, pos, state.func_177230_c(), null, false);
                    } else {
                        player.func_145747_a((ITextComponent)this.text__cycle_rod_normal, player.func_110124_au());
                    }
                }
                if (item instanceof DyeItem) {
                    DyeColor edc = DyeColor.getColor((ItemStack)heldItem);
                    float red = edc.func_193349_f()[0];
                    float green = edc.func_193349_f()[1];
                    float blue = edc.func_193349_f()[2];
                    int color = (int)(red * 255.0f);
                    color = (color << 8) + (int)(green * 255.0f);
                    color = (color << 8) + (int)(blue * 255.0f);
                    if (telepad_tile_entity.getColorFeet() == TileEntityTelepad.COLOR_FEET_BASE) {
                        telepad_tile_entity.setFeetColor(color);
                    } else if (telepad_tile_entity.getColorArrow() == TileEntityTelepad.COLOR_ARROW_BASE) {
                        telepad_tile_entity.setArrowColor(color);
                    }
                    telepad_tile_entity.func_70296_d();
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
                    if (!player.func_184812_l_()) {
                        heldItem.func_190918_g(1);
                    }
                }
                if (item.equals(Items.field_151131_as)) {
                    boolean hasWashed = false;
                    if (telepad_tile_entity.getColorFeet() != TileEntityTelepad.COLOR_FEET_BASE) {
                        this.wash(telepad_tile_entity.getColorFeet(), world, pos);
                        telepad_tile_entity.setFeetColor(TileEntityTelepad.COLOR_FEET_BASE);
                        hasWashed = true;
                    }
                    if (telepad_tile_entity.getColorArrow() != TileEntityTelepad.COLOR_ARROW_BASE) {
                        this.wash(telepad_tile_entity.getColorArrow(), world, pos);
                        telepad_tile_entity.setArrowColor(TileEntityTelepad.COLOR_ARROW_BASE);
                        hasWashed = true;
                    }
                    if (!player.func_184812_l_() && hasWashed) {
                        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f, true);
                        player.func_184611_a(hand, heldItem.getContainerItem());
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        } else if (player.func_225608_bj_() && world.func_175625_s(pos) instanceof TileEntityTelepad && (entry = WorldDataHandler.get((IWorld)world).getEntryForLocation(pos, (RegistryKey<World>)world.func_234923_W_())) != null && Hand.MAIN_HAND.equals((Object)hand)) {
            if (!entry.canUse(player.func_110124_au())) {
                Style style = Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GREEN));
                IFormattableTextComponent msg = this.cycle_add_success.func_230532_e_().func_240702_b_(entry.entryName);
                player.func_145747_a((ITextComponent)msg.func_230530_a_(style), player.func_110124_au());
                entry.addUser(player.func_110124_au());
                return ActionResultType.SUCCESS;
            }
            if (!entry.isPublic) {
                Style style = Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.GOLD));
                IFormattableTextComponent msg = this.cycle_add_remove.func_230532_e_().func_240702_b_(entry.entryName).func_230530_a_(style);
                player.func_145747_a((ITextComponent)msg, player.func_110124_au());
                entry.removeUser(player.func_110124_au());
                return ActionResultType.SUCCESS;
            }
            IFormattableTextComponent msg = this.cycle_add_fail.func_230532_e_().func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED)));
            player.func_145747_a((ITextComponent)msg, player.func_110124_au());
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    private void wash(int color, World world, BlockPos pos) {
        DyeColor edc = DyeColor.WHITE;
        for (DyeColor dye : DyeColor.values()) {
            if (dye.func_193349_f()[0] != (float)((color & 0xFF0000) >> 16) / 255.0f || dye.func_193349_f()[1] != (float)((color & 0xFF00) >> 8) / 255.0f || dye.func_193349_f()[2] != (float)((color & 0xFF) >> 0) / 255.0f) continue;
            edc = dye;
        }
        ItemStack stack = new ItemStack((IItemProvider)DyeItem.func_195961_a((DyeColor)edc), 1);
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntity te = world.func_175625_s(pos);
        TileEntityTelepad tet = null;
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return;
        }
        tet = (TileEntityTelepad)te;
        if (!tet.hasRedstoneUpgrade()) {
            return;
        }
        Direction[] facesThatCanPower = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};
        boolean isPowered = false;
        for (Direction face : facesThatCanPower) {
            if (!world.func_180495_p(pos.func_177972_a(face)).func_185897_m()) continue;
            int power = world.func_180495_p(pos.func_177972_a(face)).func_185893_b((IBlockReader)world, pos, face);
            int weakPower = world.func_180495_p(pos.func_177972_a(face)).func_185911_a((IBlockReader)world, pos, face);
            if (power <= 0 && weakPower <= 0) continue;
            isPowered = true;
            break;
        }
        tet.setPowered(isPowered);
        tet.func_70296_d();
        world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
        WorldDataHandler wdh = WorldDataHandler.get((IWorld)world);
        TelepadEntry entry = wdh.getEntryForLocation(pos, (RegistryKey<World>)world.func_234923_W_());
        entry.isPowered = isPowered;
        wdh.updateEntry(entry);
        wdh.func_76185_a();
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile_entity = world.func_175625_s(pos);
        TileEntityTelepad tile_entity_telepad = null;
        if (tile_entity == null || !(tile_entity instanceof TileEntityTelepad)) {
            return;
        }
        tile_entity_telepad = (TileEntityTelepad)tile_entity;
        if (placer instanceof ServerPlayerEntity) {
            tile_entity_telepad.setDimension((RegistryKey<World>)world.func_234923_W_());
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b("colorFrame")) {
                    tile_entity_telepad.setFeetColor(stack.func_77978_p().func_74762_e("colorFrame"));
                }
                if (stack.func_77978_p().func_74764_b("colorBase")) {
                    tile_entity_telepad.setArrowColor(stack.func_77978_p().func_74762_e("colorBase"));
                }
            }
            tile_entity.func_70296_d();
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 3);
            world.func_175690_a(pos, tile_entity);
            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)placer), (Object)new CPacketRequestNamingScreen(pos));
        }
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity tile_entity = world.func_175625_s(pos);
        TileEntityTelepad tile_entity_telepad = null;
        if (tile_entity == null || !(tile_entity instanceof TileEntityTelepad)) {
            return false;
        }
        tile_entity_telepad = (TileEntityTelepad)tile_entity;
        if (world.field_72995_K) {
            return false;
        }
        WorldDataHandler wdh = WorldDataHandler.get((IWorld)world);
        TelepadEntry entry = wdh.getEntryForLocation(pos, (RegistryKey<World>)world.func_234923_W_());
        if (entry != null) {
            entry.isMissingFromLocation = true;
            this.dropPad(world, tile_entity_telepad, pos);
            if (tile_entity_telepad.hasDimensionUpgrade()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Telepads.ObjectHolders.TRANSMITTER, 1)));
            }
            if (tile_entity_telepad.hasRedstoneUpgrade()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack((IItemProvider)Telepads.ObjectHolders.TOGGLER, 1)));
            }
            return world.func_217377_a(pos, false);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    private void dropPad(World world, TileEntityTelepad telepad, BlockPos pos) {
        ItemEntity item_entity = new ItemEntity(EntityType.field_200765_E, world);
        item_entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        ItemStack stack = new ItemStack((IItemProvider)Telepads.ObjectHolders.TELEPAD_BLOCK);
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("colorBase", telepad.getColorArrow());
        nbt.func_74768_a("colorFrame", telepad.getColorFeet());
        stack.func_77982_d(nbt);
        item_entity.func_92058_a(stack);
        world.func_217376_c((Entity)item_entity);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return entity instanceof PlayerEntity;
    }

    public float getExplosionResistance(BlockState state, IBlockReader world, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null || !(te instanceof TileEntityTelepad)) {
            return;
        }
        if (((TileEntityTelepad)te).isPowered()) {
            return;
        }
        int maxParticleCount = ((TileEntityTelepad)te).isStandingOnPlatform() ? 15 : 1;
        for (int particleCount = 0; particleCount < maxParticleCount; ++particleCount) {
            if (((TileEntityTelepad)te).getCoordinateHandlerIndex() > -1) {
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        if (i > -2 && i < 2 && j == -1) {
                            j = 2;
                        }
                        if (random.nextInt(4) != 0) continue;
                        for (int k = 0; k <= 2; ++k) {
                            world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, (double)((float)i + random.nextFloat()) - 0.5, (double)((float)k - random.nextFloat() - 0.0f), (double)((float)j + random.nextFloat()) - 0.5);
                        }
                    }
                }
                continue;
            }
            double posX = (float)pos.func_177958_n() + 0.5f;
            double posY = (float)pos.func_177956_o() + random.nextFloat() * 1.5f;
            double posZ = (float)pos.func_177952_p() + 0.5f;
            double velocityX = 0.0;
            double velocityY = 0.0;
            double velocityZ = 0.0;
            int velocityXOffset = random.nextInt(2) * 2 - 1;
            int velocityZOffset = random.nextInt(2) * 2 - 1;
            velocityX = ((double)random.nextFloat() - 0.5) * 0.125;
            velocityY = ((double)random.nextFloat() - 0.5) * 0.125;
            velocityZ = ((double)random.nextFloat() - 0.5) * 0.125;
            velocityX = random.nextFloat() * 1.0f * (float)velocityXOffset;
            velocityZ = random.nextFloat() * 1.0f * (float)velocityZOffset;
            world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, posX, posY, posZ, velocityX, velocityY, velocityZ);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        WorldDataHandler wdh;
        TelepadEntry entry;
        super.func_176208_a(worldIn, pos, state, player);
        if (!worldIn.func_201670_d() && (entry = (wdh = WorldDataHandler.get((IWorld)worldIn)).getEntryForLocation(pos, (RegistryKey<World>)worldIn.func_234923_W_())) != null) {
            entry.isMissingFromLocation = true;
        }
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        WorldDataHandler wdh;
        TelepadEntry entry;
        super.onBlockExploded(state, world, pos, explosion);
        if (!world.func_201670_d() && (entry = (wdh = WorldDataHandler.get((IWorld)world)).getEntryForLocation(pos, (RegistryKey<World>)world.func_234923_W_())) != null) {
            entry.isMissingFromLocation = true;
        }
    }
}

