/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean allowDragonBlocking;
    public static boolean allowAnvilPearls;
    public static boolean disableBeadsUsage;
    public static boolean disableNecklaceUsage;
    public static String[] tp_locations;
    public static int teleport_seconds;
    public static int expConsume;
    public static int lvlConsume;
    public static boolean consumeLvl;
    public static boolean allowParticles;

    public static void refreshServer() {
    }

    public static void refreshClient() {
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
        allowDragonBlocking = true;
        allowAnvilPearls = true;
        disableBeadsUsage = false;
        disableNecklaceUsage = false;
        tp_locations = new String[0];
        teleport_seconds = 3;
        allowParticles = true;
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue allowParticles;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Rendering");
            this.allowParticles = builder.comment("Some people find them annoying. Feel free to disable them here if needed").translation("config.particles.telepad.allow").define("Allow Particle Spawning", true);
            builder.pop();
        }
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue allowDragonBlocking;
        public final ForgeConfigSpec.BooleanValue allowAnvilPearls;
        public final ForgeConfigSpec.BooleanValue disableBeadsUsage;
        public final ForgeConfigSpec.BooleanValue disableNecklaceUsage;
        public final ForgeConfigSpec.IntValue exp;
        public final ForgeConfigSpec.IntValue lvl;
        public final ForgeConfigSpec.IntValue teleport_delay;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> val;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Teleporting from and to the End");
            this.allowDragonBlocking = builder.comment("Wether to allow the presence of the Ender Dragon to prevent teleporting away from the End").translation("config.block.dragon").define("Dragon Teleport Block", true);
            builder.pop();
            builder.push("Teleport Items");
            this.allowAnvilPearls = builder.comment("Disable creation of Ender Beads here").translation("config.anvil.allow").define("Allow anvil pearl crafting", true);
            this.disableBeadsUsage = builder.comment("Disable usage of the Ender Beads here").translation("config.beads.allow").define("Allow Ender Bead usage", true);
            this.disableNecklaceUsage = builder.comment("Dsiabe usage of the Ender Necklace here").translation("config.necklace.allow").define("Allow Ender Necklace usage", true);
            builder.pop();
            builder.push("Teleportation Details");
            this.exp = builder.comment("Penalty cost for teleportation, if set to 0, there will be no exp loss. Set level to 0 if you onyl want to consume an amount of exp.").translation("config.consume.exp").defineInRange("Experience Consumation", 0, 0, 10000);
            this.lvl = builder.comment("Penalty cost for teleportation, if set to 0, there will be no exp loss. set experience to 0 if you want to consume levels.").translation("config.consume.level").defineInRange("Level Consumation", 0, 0, 32);
            this.teleport_delay = builder.comment("Delay, in seconds, on how long a player must wait on the telepad block before the gui opens").translation("config.tele.gui.open").defineInRange("Teleport GUI Delay", 3, 1, 60);
            builder.pop();
            this.val = builder.comment(String.format("[x,y,z,dimension,locationName] locations can be defined in multiple ways :\nexactly(100/64/100/0/Any Name really),\nwith margin (-500#1000/64#128/0#500/-1#1,Some Location Name)\nor random (random/random/random/random/LocationNameHere).values can be mixed (-100#5000/random/100/0/yourLocationNameHere) is totally possible", new Object[0])).defineList("reflection_whitelisted_blocks", (List)Lists.newArrayList(), obj -> obj instanceof String);
        }
    }
}

