/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;

public class CoordinateHandler {
    public static final Random rand = new Random();
    public int worldsize = 25000000;
    int xi = 0;
    int zi = 0;
    String yi = "";
    ResourceLocation dim = null;
    String name = "default";

    public CoordinateHandler(ServerWorld server, String args) {
        String[] s = args.split("/");
        this.xi = this.define(s[0]);
        this.yi = s[1];
        this.zi = this.define(s[2]);
        this.defineDim(server, s[3]);
        this.name = s[4];
    }

    public String getName() {
        return this.name;
    }

    private int define(String definer) {
        if (definer.toLowerCase().equals("random")) {
            int random = rand.nextInt(this.worldsize * 2) - this.worldsize;
            return random;
        }
        if (definer.contains("#")) {
            String[] vals = definer.split("#");
            int min = Integer.valueOf(vals[0]);
            int max = Integer.valueOf(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            int total = 0;
            total = min < 0 && max >= 0 ? max + -1 * min : max + min;
            int result = rand.nextInt(total);
            if (min < 0 && max >= 0) {
                result += min;
            }
            return result;
        }
        return Integer.valueOf(definer);
    }

    private void defineDim(ServerWorld world, String dimension) {
        if (dimension.toLowerCase().equals("random")) {
            ResourceLocation resLoc;
            ArrayList list = Lists.newArrayList();
            for (ServerWorld dim : world.func_73046_m().func_212370_w()) {
                list.add(dim.func_234923_W_().func_240901_a_());
            }
            this.dim = resLoc = (ResourceLocation)list.get(rand.nextInt(list.size()));
        } else {
            this.dim = new ResourceLocation(dimension);
        }
    }

    private int defineY(String definer, World world) {
        if (definer.toLowerCase().equals("random")) {
            world.func_217349_x(new BlockPos(this.xi, 0, this.zi));
            if (world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.xi, this.zi) > 0) {
                return world.func_201676_a(Heightmap.Type.WORLD_SURFACE, this.xi, this.zi);
            }
            return 0;
        }
        if (definer.contains("#")) {
            int counter;
            String[] vals = definer.split("#");
            int min = Integer.valueOf(vals[0]);
            int max = Integer.valueOf(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            BlockPos pos = new BlockPos(this.xi, min, this.zi);
            for (counter = min; counter < max; ++counter) {
                if (world.func_180495_p(pos).func_215686_e((IBlockReader)world, pos) && world.func_175623_d(pos.func_177984_a())) break;
                pos = new BlockPos(this.xi, counter, this.zi);
            }
            int result = counter;
            if (counter >= max) {
                result = min < 0 && max >= 0 ? max + -1 * min : max + min;
                result = result / 2 + min;
            }
            return result;
        }
        return Integer.valueOf(definer);
    }

    public BlockPos getPosition(World world) {
        int y = this.defineY(this.yi, world);
        return new BlockPos(this.xi, y, this.zi);
    }

    public ResourceLocation getDimension() {
        return this.dim;
    }
}

