/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.utility.PropertiesWrapper;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class ItemEnderNecklace
extends Item {
    public ItemEnderNecklace() {
        super(PropertiesWrapper.getItemProperties().func_200917_a(8).func_200916_a(ItemGroup.field_78035_l));
        this.setRegistryName("telepads", "ender_bead_necklace");
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (ConfigData.disableNecklaceUsage) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new StringTextComponent("This Functionality has been disabled by the server operator."), player.func_110124_au());
            }
            return super.func_77659_a(world, player, hand);
        }
        if (!world.field_72995_K) {
            WorldDataHandler wdh = WorldDataHandler.get((IWorld)world);
            List<TelepadEntry> locations = wdh.getEntries();
            ArrayList thisDim = new ArrayList();
            if (locations.isEmpty()) {
                return super.func_77659_a(world, player, hand);
            }
            ResourceLocation dim = world.func_234923_W_().func_240901_a_();
            locations.stream().filter(filter -> filter.dimensionID.equals((Object)dim) && filter.canUse(player.func_110124_au()) && !filter.isPowered).forEach(telepad -> thisDim.add(telepad));
            if (thisDim.isEmpty()) {
                return super.func_77659_a(world, player, hand);
            }
            double distance = Double.MAX_VALUE;
            TelepadEntry closestEntry = null;
            for (TelepadEntry entry : thisDim) {
                double distanceSQ = entry.position.func_218140_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), true);
                if (!(distance > distanceSQ)) continue;
                distance = distanceSQ;
                closestEntry = entry;
            }
            if (closestEntry != null) {
                player.func_184586_b(hand).func_190918_g(1);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Items.field_151007_F, world.field_73012_v.nextInt(2) + 1));
                }
                Teleport.teleportEntityInsideSameDimension((Entity)player, closestEntry.position.func_177968_d().func_177976_e());
                world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.6f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.1f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
                world.func_184148_a((PlayerEntity)null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187546_ae, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            }
        }
        return super.func_77659_a(world, player, hand);
    }
}

