/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.network.NetworkEvent;
import subaraki.telepads.network.IPacketBase;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.utility.ClientReferences;
import subaraki.telepads.utility.TelepadEntry;

public class CPacketRequestTeleportScreen
implements IPacketBase {
    public List<TelepadEntry> entries;
    public Collection<UUID> whiteList;
    public boolean has_transmitter;

    public CPacketRequestTeleportScreen(List<TelepadEntry> entries, Collection<UUID> whiteList, boolean has_transmitter) {
        this.entries = entries;
        this.whiteList = whiteList;
        this.has_transmitter = has_transmitter;
    }

    public CPacketRequestTeleportScreen(PacketBuffer buf) {
        this.decode(buf);
    }

    public CPacketRequestTeleportScreen() {
    }

    @Override
    public void encode(PacketBuffer buf) {
        buf.writeInt(this.entries.size());
        for (TelepadEntry entry : this.entries) {
            entry.writeToBuffer(buf);
        }
        buf.writeInt(this.whiteList.size());
        for (UUID s : this.whiteList) {
            buf.func_179252_a(s);
        }
        buf.writeBoolean(this.has_transmitter);
    }

    @Override
    public void decode(PacketBuffer buf) {
        int size = buf.readInt();
        if (size <= 0) {
            return;
        }
        ArrayList entryList = Lists.newArrayList();
        for (int index = 0; index < size; ++index) {
            entryList.add(new TelepadEntry(buf));
        }
        this.entries = entryList;
        size = buf.readInt();
        ArrayList whiteList = Lists.newArrayList();
        for (int i = 0; i < size; ++i) {
            whiteList.add(buf.func_179253_g());
        }
        this.whiteList = whiteList;
        this.has_transmitter = buf.readBoolean();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                ClientReferences.handlePacket(this);
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void register(int id) {
        NetworkHandler.NETWORK.registerMessage(id, CPacketRequestTeleportScreen.class, CPacketRequestTeleportScreen::encode, CPacketRequestTeleportScreen::new, CPacketRequestTeleportScreen::handle);
    }
}

