/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.UUID;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketAddTelepadToWorld;
import subaraki.telepads.utility.TelepadEntry;

public class NameTelepadScreen
extends Screen {
    private TextFieldWidget textField;
    private int field_width = 150;
    private int field_height = 20;
    private int center_x;
    private int center_y;
    private String text_share = new TranslationTextComponent("button.share").getString();
    private String text_confirm_share = new TranslationTextComponent("confirm.share").getString();
    private String text_negate_share = new TranslationTextComponent("negate.share").getString();
    private String enter = new TranslationTextComponent("enter.to.confirm").getString();
    private String nameYourPad;
    private boolean share = false;
    String sharing = "";
    private boolean should_show_sharing;
    private BlockPos position;

    public NameTelepadScreen(BlockPos position) {
        super((ITextComponent)new TranslationTextComponent("name.pick.screen"));
        this.position = position;
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.center_x = this.field_230708_k_ / 2;
        this.center_y = this.field_230709_l_ / 2;
        this.initTextField();
        IFormattableTextComponent translation = new TranslationTextComponent("name.your.telepad").func_230529_a_((ITextComponent)new StringTextComponent(" : "));
        this.nameYourPad = translation.getString();
        this.initButtons();
    }

    private void initButtons() {
        TelepadData.get((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(data -> {
            if (!data.getWhitelist().isEmpty()) {
                this.should_show_sharing = true;
                this.func_230480_a_((Widget)new Button(this.center_x - 40, this.center_y + 20, 45, 20, (ITextComponent)new TranslationTextComponent(this.text_share), b -> {
                    this.share = !this.share;
                }));
            }
        });
    }

    private void initTextField() {
        this.textField = new TextFieldWidget(this.field_230712_o_, this.center_x - this.field_width / 2, this.center_y - 50, this.field_width, this.field_height, (ITextComponent)new StringTextComponent("field_name"));
        this.textField.func_146185_a(true);
        this.textField.func_146184_c(true);
        this.textField.func_146205_d(false);
        this.textField.func_146195_b(true);
        ResourceLocation resLoc = this.field_230706_i_.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.field_230706_i_.field_71441_e.func_226691_t_(this.field_230706_i_.field_71439_g.func_233580_cy_()));
        String biome_name = "biome." + resLoc.func_110624_b() + "." + resLoc.func_110623_a();
        TranslationTextComponent biome = new TranslationTextComponent(biome_name);
        String format_name = biome.getString().substring(0, Math.min(15, biome.getString().length()));
        this.textField.func_146180_a(format_name);
        this.textField.func_146203_f(16);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.textField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.should_show_sharing) {
            this.sharing = this.share ? this.text_confirm_share : this.text_negate_share;
        }
        this.field_230712_o_.func_238405_a_(matrixStack, this.sharing, (float)(this.center_x - this.field_230712_o_.func_78256_a(this.sharing) / 2 + 30), (float)(this.center_y + 27), 0xAFAFAF);
        this.field_230712_o_.func_238405_a_(matrixStack, this.enter, (float)(this.center_x - this.field_230712_o_.func_78256_a(this.enter) / 2), (float)this.center_y, 0xFFFFFF);
        this.field_230712_o_.func_238405_a_(matrixStack, this.nameYourPad + this.textField.func_146179_b(), (float)(this.center_x - this.field_230712_o_.func_78256_a(this.nameYourPad + this.textField.func_146179_b()) / 2), (float)(this.center_y - this.field_height), 0xFF0000);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int p_keyPressed_3_) {
        this.textField.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
        if (keyCode == 257 || keyCode == 335 || keyCode == 256) {
            TelepadData.get((PlayerEntity)this.field_230706_i_.field_71439_g).ifPresent(data -> {
                TelepadEntry telepad_entry = new TelepadEntry(this.textField.func_146179_b(), (RegistryKey<World>)this.field_230706_i_.field_71441_e.func_234923_W_(), this.position);
                telepad_entry.addUser(this.field_230706_i_.field_71439_g.func_110124_au());
                if (this.share) {
                    data.getWhitelist().values().forEach(entry -> telepad_entry.addUser((UUID)entry));
                }
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketAddTelepadToWorld(telepad_entry));
            });
            this.func_231175_as__();
            this.func_231164_f_();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean func_231042_a_(char car, int index) {
        this.textField.func_231042_a_(car, index);
        return super.func_231042_a_(car, index);
    }
}

