/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketTeleport;
import subaraki.telepads.tileentity.render.RenderEndPortalFrame;
import subaraki.telepads.utility.ClientReferences;
import subaraki.telepads.utility.TelepadEntry;

public class TeleportScreen
extends Screen {
    private LinkedList<TelepadEntry> entries = new LinkedList();
    private RegistryKey<World> lookup_dim_id = World.field_234918_g_;
    private RenderEndPortalFrame endPortalFrame;
    private int scrollbarscroll = 0;
    TextFieldWidget dimension_indicator;
    protected final List<Widget> unscrollables = Lists.newArrayList();
    protected List<RegistryKey<World>> dimensions_visited = Lists.newArrayList();
    private final boolean is_transmitter_pad;
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private int tuner_counter = 0;

    public TeleportScreen(boolean is_transmitter_pad) {
        super((ITextComponent)new TranslationTextComponent("telepad.gui"));
        this.is_transmitter_pad = is_transmitter_pad;
        this.endPortalFrame = new RenderEndPortalFrame();
    }

    public boolean func_231177_au__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.lookup_dim_id = this.field_230706_i_.field_71441_e.func_234923_W_();
        this.scrollbarscroll = 0;
        this.dimension_indicator = new TextFieldWidget(this.field_230712_o_, this.field_230706_i_.func_228018_at_().func_198107_o() / 2 - 75, 5, 150, 20, (ITextComponent)new TranslationTextComponent("indicator"));
        this.dimension_indicator.func_146180_a(this.lookup_dim_id.func_240901_a_().func_110623_a());
        this.initialize_pages();
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.endPortalFrame.renderEndPortalSurfaceGUI(stack, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_(), mouseX, mouseY);
        TeleportScreen.func_238467_a_((MatrixStack)stack, (int)10, (int)30, (int)(this.field_230708_k_ - 10), (int)(this.field_230709_l_ - 30), (int)0x55444444);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        MainWindow window = this.field_230706_i_.func_228018_at_();
        int scale = (int)window.func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)(10 * scale), (int)(30 * scale), (int)(this.field_230708_k_ * scale), (int)((this.field_230709_l_ - 60) * scale));
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        GL11.glDisable((int)3089);
        if (!this.field_230710_m_.isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.dimension_indicator.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.unscrollables.forEach(b -> b.func_230430_a_(stack, mouseX, mouseY, partialTicks));
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double mouseScroll) {
        int index = this.field_230710_m_.size() > 0 ? this.field_230710_m_.size() - 1 : 0;
        Widget last = (Widget)this.field_230710_m_.get(index);
        Widget first = (Widget)this.field_230710_m_.get(0);
        int forsee_bottom_limit = (int)((double)(last.field_230691_m_ + last.func_238483_d_()) + mouseScroll * 16.0);
        int bottom_limit = this.field_230709_l_ - 30 - last.func_238483_d_();
        int forsee_top_limit = (int)((double)(first.field_230691_m_ - 15) + mouseScroll * 16.0);
        int top_limit = 35;
        if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
            return super.func_231043_a_(mouseX, mouseY, mouseScroll);
        }
        if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
            return super.func_231043_a_(mouseX, mouseY, mouseScroll);
        }
        this.move(mouseScroll);
        return super.func_231043_a_(mouseX, mouseY, mouseScroll);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        return super.func_231045_a_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
    }

    private void drawFakeScrollBar(MatrixStack stack) {
        int top = ((Widget)this.field_230710_m_.get((int)0)).field_230691_m_;
        float containerSize = this.field_230709_l_ - 60;
        int bot = ((Widget)this.field_230710_m_.get((int)(this.field_230710_m_.size() - 1))).field_230691_m_ + ((Widget)this.field_230710_m_.get(this.field_230710_m_.size() - 1)).func_238483_d_();
        float totalSize = bot - top + 5;
        float percent = containerSize / totalSize * 100.0f;
        if (percent < 100.0f) {
            float sizeBar = containerSize / 100.0f * percent;
            float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
            this.func_238468_a_(stack, this.field_230708_k_ - 10, 30, this.field_230708_k_, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
            this.func_238468_a_(stack, this.field_230708_k_ - 10, 30 + (int)relativeScroll, this.field_230708_k_, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
        }
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget button : this.field_230710_m_) {
            button.field_230691_m_ = (int)((double)button.field_230691_m_ + scroll * 16.0);
        }
    }

    private void setup_dimension_page() {
        int max_collumns;
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        TelepadData.get((PlayerEntity)player).ifPresent(data -> {
            for (TelepadEntry entry : data.getEntries()) {
                if (!entry.dimensionID.equals(this.lookup_dim_id)) continue;
                this.entries.add(entry);
            }
        });
        int increment = max_collumns = this.field_230706_i_.func_228018_at_().func_198107_o() / 130;
        int central_offset = this.field_230706_i_.func_228018_at_().func_198107_o() / 2 - max_collumns * 120 / 2;
        for (TelepadEntry entry : this.entries) {
            int extra_y = increment / max_collumns;
            int extra_x = increment % max_collumns;
            TextFormatting color = entry.isMissingFromLocation ? TextFormatting.GRAY : (entry.isPowered ? TextFormatting.DARK_RED : (entry.hasTransmitter ? TextFormatting.GREEN : (entry.isPublic ? TextFormatting.LIGHT_PURPLE : TextFormatting.WHITE)));
            this.func_230480_a_((Widget)new Button(central_offset + 5 + extra_x * 120, 15 + extra_y * 25, 110, 20, (ITextComponent)new StringTextComponent(entry.entryName).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240744_a_((TextFormatting)color))), button -> {
                if (entry.isMissingFromLocation) {
                    this.func_231164_f_();
                    this.func_231175_as__();
                    ClientReferences.openMissingScreen(entry);
                } else {
                    NetworkHandler.NETWORK.sendToServer((Object)new SPacketTeleport(this.field_230706_i_.field_71439_g.func_233580_cy_(), entry, false));
                    this.func_231164_f_();
                    this.func_231175_as__();
                }
            }));
            ++increment;
        }
    }

    private void add_paging_buttons() {
        while (this.dimensions_visited.get(this.tuner_counter) != this.lookup_dim_id) {
            ++this.tuner_counter;
        }
        int centerx = this.field_230706_i_.func_228018_at_().func_198107_o() / 2;
        Button button_left = new Button(centerx - 75 - 25, 5, 20, 20, (ITextComponent)new StringTextComponent("<"), button -> {
            if (this.dimensions_visited.size() > 1) {
                --this.tuner_counter;
                if (this.tuner_counter < 0) {
                    this.tuner_counter = this.dimensions_visited.size() - 1;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.func_146180_a(this.lookup_dim_id.func_240901_a_().func_110623_a());
            this.initialize_pages();
        });
        Button button_right = new Button(centerx + 75 + 5, 5, 20, 20, (ITextComponent)new StringTextComponent(">"), button -> {
            if (this.dimensions_visited.size() > 1) {
                ++this.tuner_counter;
                if (this.tuner_counter >= this.dimensions_visited.size()) {
                    this.tuner_counter = 0;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.func_146180_a(this.lookup_dim_id.func_240901_a_().func_110623_a());
            this.initialize_pages();
        });
        this.unscrollables.add((Widget)button_left);
        this.unscrollables.add((Widget)button_right);
        this.field_230705_e_.add(button_left);
        this.field_230705_e_.add(button_right);
    }

    private void initialize_pages() {
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.entries.clear();
        this.unscrollables.clear();
        this.dimensions_visited.clear();
        this.setup_dimension_list();
        this.setup_dimension_page();
        if (this.is_transmitter_pad) {
            this.add_paging_buttons();
        }
    }

    private void setup_dimension_list() {
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        TelepadData.get((PlayerEntity)player).ifPresent(data -> data.getEntries().forEach(entry -> {
            if (!this.dimensions_visited.contains(entry.dimensionID)) {
                this.dimensions_visited.add(entry.dimensionID);
            }
        }));
    }
}

