/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketRequestTeleportScreen;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class TileEntityTelepad
extends TileEntity
implements ITickableTileEntity {
    private RegistryKey<World> dimension;
    public static final int COLOR_FEET_BASE = new Color(26, 246, 172).getRGB();
    public static final int COLOR_ARROW_BASE = new Color(243, 89, 233).getRGB();
    private int colorFrame = COLOR_FEET_BASE;
    private int colorBase = COLOR_ARROW_BASE;
    private int upgradeRotation = 0;
    private boolean hasDimensionUpgrade = false;
    private boolean hasRedstoneUpgrade = false;
    private boolean isPowered = false;
    private boolean isPublic = false;
    private boolean isStandingOnPlatform;
    private int coordinate_handler_index = -1;

    public TileEntityTelepad() {
        super(Telepads.ObjectHolders.TILE_ENTITY_TELEPAD);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        String dim = compound.func_74779_i("dimension");
        this.hasDimensionUpgrade = compound.func_74767_n("upgrade_dimension");
        this.hasRedstoneUpgrade = compound.func_74767_n("upgrade_redstone");
        this.isPowered = compound.func_74767_n("is_powered");
        this.colorBase = compound.func_74762_e("colorBase");
        this.colorFrame = compound.func_74762_e("colorFrame");
        this.upgradeRotation = compound.func_74762_e("upgradeRotation");
        this.isStandingOnPlatform = compound.func_74767_n("standingon");
        this.coordinate_handler_index = compound.func_74762_e("mod_tp");
        this.isPublic = compound.func_74767_n("public");
        if (!dim.isEmpty()) {
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dim));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        compound.func_74757_a("upgrade_dimension", this.hasDimensionUpgrade);
        compound.func_74757_a("upgrade_redstone", this.hasRedstoneUpgrade);
        compound.func_74757_a("is_powered", this.isPowered);
        compound.func_74768_a("colorBase", this.colorBase);
        compound.func_74768_a("colorFrame", this.colorFrame);
        compound.func_74768_a("upgradeRotation", this.upgradeRotation);
        compound.func_74757_a("standingon", this.isStandingOnPlatform);
        compound.func_74768_a("mod_tp", this.coordinate_handler_index);
        compound.func_74757_a("public", this.isPublic);
        return compound;
    }

    public void func_73660_a() {
        if (this.isPowered) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v());
            List list = this.field_145850_b.func_217357_a(ServerPlayerEntity.class, aabb);
            if (!list.isEmpty()) {
                this.setPlatform(true);
                for (ServerPlayerEntity player_standing_on_pad : list) {
                    TelepadData.get((PlayerEntity)player_standing_on_pad).ifPresent(player_data -> {
                        if (player_data.getRequestTeleportScreen()) {
                            player_data.setRequestTeleportScreen(false);
                            TelepadEntry telepad = WorldDataHandler.get((IWorld)this.func_145831_w()).getEntryForLocation(this.func_174877_v(), this.dimension);
                            boolean is_transmitter = telepad == null ? false : telepad.hasTransmitter;
                            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> player_standing_on_pad), (Object)new CPacketRequestTeleportScreen(player_data.getEntries(), player_data.getWhitelist().values(), is_transmitter));
                            return;
                        }
                        if (player_data.getCounter() > 0 && !player_data.isInTeleportGui()) {
                            --player_data.counter;
                        } else if (player_data.getCounter() == 0 && !player_data.isInTeleportGui()) {
                            if (this.field_145850_b.func_234923_W_().equals(World.field_234920_i_) && ConfigData.allowDragonBlocking && this.field_145850_b instanceof ServerWorld && !((ServerWorld)this.field_145850_b).func_217439_j().isEmpty()) {
                                player_data.setCounter(TelepadData.getMaxTime());
                                player_standing_on_pad.func_145747_a((ITextComponent)new TranslationTextComponent("dragon.obstructs").func_230530_a_(Style.field_240709_b_.func_240718_a_(net.minecraft.util.text.Color.func_240744_a_((TextFormatting)TextFormatting.DARK_PURPLE)).func_240722_b_(Boolean.valueOf(true))), player_standing_on_pad.func_110124_au());
                                return;
                            }
                            if (this.getCoordinateHandlerIndex() > -1) {
                                int index = this.getCoordinateHandlerIndex();
                                String[] tpl = ConfigData.tp_locations;
                                CoordinateHandler coords = new CoordinateHandler((ServerWorld)this.field_145850_b, tpl[index]);
                                ResourceLocation dimension = coords.getDimension();
                                if (!player_standing_on_pad.field_70170_p.func_234923_W_().func_240901_a_().equals((Object)dimension)) {
                                    MinecraftServer server = player_standing_on_pad.func_184102_h();
                                    RegistryKey dim_key = null;
                                    for (ServerWorld dim : server.func_212370_w()) {
                                        if (!dim.func_234923_W_().func_240901_a_().equals((Object)dimension)) continue;
                                        dim_key = dim.func_234923_W_();
                                    }
                                    if (dim_key == null) {
                                        return;
                                    }
                                    ServerWorld worldDestination = server.func_71218_a(this.field_145850_b.func_234923_W_());
                                    BlockPos pos = coords.getPosition((World)worldDestination);
                                    Teleport.teleportEntityToDimension(player_standing_on_pad, pos, (RegistryKey<World>)dim_key);
                                } else {
                                    BlockPos pos = coords.getPosition(this.func_145831_w());
                                    Teleport.teleportEntityInsideSameDimension((Entity)player_standing_on_pad, pos);
                                }
                            } else {
                                player_data.setInTeleportGui(true);
                                player_data.setCounter(TelepadData.getMaxTime());
                                this.activateTelepadGui(player_standing_on_pad);
                            }
                        }
                    });
                }
            } else {
                this.setPlatform(false);
            }
        }
    }

    public void setPlatform(boolean onPlatform) {
        this.isStandingOnPlatform = onPlatform;
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), Telepads.ObjectHolders.TELEPAD_BLOCK.func_176223_P(), 3);
    }

    private void activateTelepadGui(ServerPlayerEntity player) {
        TelepadData.get((PlayerEntity)player).ifPresent(data -> {
            ServerWorld world = player.func_71121_q();
            WorldDataHandler save = WorldDataHandler.get((IWorld)world);
            List<TelepadEntry> world_save_entries = save.getEntries();
            data.getEntries().clear();
            world_save_entries.stream().filter(entry -> entry.canUse(player.func_110124_au())).forEach(entry -> data.addEntry((TelepadEntry)entry));
            data.setRequestTeleportScreen(true);
        });
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public void setDimension(RegistryKey<World> dimensionID) {
        this.dimension = dimensionID;
    }

    public void setFeetColor(int rgb) {
        this.colorFrame = rgb;
    }

    public void setArrowColor(int rgb) {
        this.colorBase = rgb;
    }

    public int getColorFeet() {
        return this.colorFrame;
    }

    public int getColorArrow() {
        return this.colorBase;
    }

    public boolean hasDimensionUpgrade() {
        return this.hasDimensionUpgrade;
    }

    public void addDimensionUpgrade(boolean allowed) {
        this.upgradeRotation = allowed ? new Random().nextInt(4) : 0;
        this.hasDimensionUpgrade = true;
    }

    public int getUpgradeRotation() {
        return this.upgradeRotation;
    }

    public boolean hasRedstoneUpgrade() {
        return this.hasRedstoneUpgrade;
    }

    public void addRedstoneUpgrade() {
        this.hasRedstoneUpgrade = true;
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setCoordinateHandlerIndex(int index) {
        this.coordinate_handler_index = index;
    }

    public void rotateCoordinateHandlerIndex() {
        ++this.coordinate_handler_index;
        if (this.coordinate_handler_index >= ConfigData.tp_locations.length) {
            this.coordinate_handler_index = -1;
        }
    }

    public int getCoordinateHandlerIndex() {
        return this.coordinate_handler_index;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean isStandingOnPlatform() {
        return this.isStandingOnPlatform;
    }

    public void toggleAcces() {
        boolean flag = !this.isPublic;
        WorldDataHandler wdh = WorldDataHandler.get((IWorld)this.func_145831_w());
        TelepadEntry tpe = wdh.getEntryForLocation(this.func_174877_v(), this.getDimension());
        tpe.setPublic(flag);
        this.isPublic = flag;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

