/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity.render;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix4f;
import subaraki.telepads.tileentity.TileEntityTelepad;

public class RenderEndPortalFrame {
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(itteration -> RenderType.func_228630_a_((int)(itteration + 1))).collect(ImmutableList.toImmutableList());

    public void render(TileEntityTelepad tileEntityIn, TileEntityRendererDispatcher renderDispatcher, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        RANDOM.setSeed(31100L);
        double d0 = tileEntityIn.func_174877_v().func_218138_a((IPosition)renderDispatcher.field_217666_g.func_216785_c(), true);
        int i = this.getPasses(d0);
        float f = this.getOffset();
        Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
        matrixStackIn.func_227861_a_(0.0, -0.55, 0.0);
        this.renderCube(f, 0.15f, matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(0)));
        for (int j = 1; j < i; ++j) {
            this.renderCube(f, 2.0f / (float)(18 - j), matrix4f, bufferIn.getBuffer(RENDER_TYPES.get(j)));
        }
    }

    private void renderCube(float offset, float pass, Matrix4f stack, IVertexBuilder vertexBuilder) {
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * pass;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * pass;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * pass;
        this.renderFace(stack, vertexBuilder, 0.0f, 1.0f, offset, offset, 1.0f, 1.0f, 0.0f, 0.0f, f, f1, f2, Direction.UP);
    }

    private void renderFaceGUI(float offset, float pass, Matrix4f stack, IVertexBuilder vertexBuilder, int mouseX, int mouseY) {
        float height;
        float f = (RANDOM.nextFloat() * 0.5f + 0.1f) * pass;
        float f1 = (RANDOM.nextFloat() * 0.5f + 0.4f) * pass;
        float f2 = (RANDOM.nextFloat() * 0.5f + 0.5f) * pass;
        float width = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        float max = width > (height = (float)Minecraft.func_71410_x().func_228018_at_().func_198087_p()) ? width : height;
        this.renderFace(stack, vertexBuilder, 0.0f, max, max, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, f, f1, f2, Direction.NORTH);
    }

    private void renderFace(Matrix4f stack, IVertexBuilder vertexBuilder, float f1, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float red, float green, float blue, Direction direction) {
        vertexBuilder.func_227888_a_(stack, f1, f3, f5).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(stack, f2, f3, f6).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(stack, f2, f4, f7).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
        vertexBuilder.func_227888_a_(stack, f1, f4, f8).func_227885_a_(red, green, blue, 1.0f).func_181675_d();
    }

    protected int getPasses(double passes) {
        if (passes > 36864.0) {
            return 1;
        }
        if (passes > 25600.0) {
            return 3;
        }
        if (passes > 16384.0) {
            return 5;
        }
        if (passes > 9216.0) {
            return 7;
        }
        if (passes > 4096.0) {
            return 9;
        }
        if (passes > 1024.0) {
            return 11;
        }
        if (passes > 576.0) {
            return 13;
        }
        return passes > 256.0 ? 14 : 15;
    }

    protected float getOffset() {
        return 0.75f;
    }

    public void renderEndPortalSurfaceGUI(MatrixStack stack, IRenderTypeBuffer buffer, int mouseX, int mouseY) {
        RANDOM.setSeed(31100L);
        int i = this.getPasses(15.0);
        float f = this.getOffset();
        Matrix4f matrix4f = stack.func_227866_c_().func_227870_a_();
        stack.func_227861_a_(0.0, 0.0, 0.0);
        this.renderFaceGUI(f, 0.15f, matrix4f, buffer.getBuffer(RENDER_TYPES.get(0)), mouseX, mouseY);
        for (int j = 1; j < i; ++j) {
            this.renderFaceGUI(f, 2.0f / (float)(18 - j), matrix4f, buffer.getBuffer(RENDER_TYPES.get(j)), mouseX, mouseY);
        }
    }
}

