/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.lwjgl.opengl.GL11;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.tileentity.render.ModelTelepad;
import subaraki.telepads.tileentity.render.RenderEndPortalFrame;

public class TileEntityTelepadRenderer
extends TileEntityRenderer<TileEntityTelepad> {
    private static ModelTelepad modeltelepad;
    private static String resourcePath;
    private static ResourceLocation base;
    private static ResourceLocation pads;
    private static ResourceLocation frame;
    private static ResourceLocation frame_upgrade;
    private static ResourceLocation frame_upgrade_2;
    private static ResourceLocation frame_upgrade_3;
    private static ResourceLocation frame_upgrade_4;
    private static int animation_counter;
    private RenderEndPortalFrame endPortalFrame;

    public TileEntityTelepadRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        modeltelepad = new ModelTelepad(RenderType::func_228640_c_);
        this.endPortalFrame = new RenderEndPortalFrame();
    }

    public void render(TileEntityTelepad te, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ++animation_counter;
        if (te == null) {
            return;
        }
        TileEntityTelepad tet = null;
        if (te instanceof TileEntityTelepad) {
            tet = te;
        }
        if (tet == null) {
            return;
        }
        if (!tet.hasRedstoneUpgrade() || tet.hasRedstoneUpgrade() && !tet.isPowered()) {
            matrixStackIn.func_227860_a_();
            this.endPortalFrame.render(tet, this.field_228858_b_, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 2.25, 0.5);
        matrixStackIn.func_227862_a_(1.0f, -1.0f, 1.0f);
        Color colorBase = new Color(tet.getColorArrow());
        Color colorFrame = new Color(tet.getColorFeet());
        this.renderPad(matrixStackIn, colorFrame, colorBase, bufferIn, combinedLightIn, combinedOverlayIn);
        if (tet.hasDimensionUpgrade()) {
            matrixStackIn.func_227860_a_();
            ResourceLocation resLocAnimation = frame_upgrade;
            if (animation_counter < 25) {
                resLocAnimation = frame_upgrade;
            } else if (animation_counter < 50) {
                resLocAnimation = frame_upgrade_2;
            } else if (animation_counter < 75) {
                resLocAnimation = frame_upgrade_3;
            } else if (animation_counter < 99) {
                resLocAnimation = frame_upgrade_4;
            } else {
                animation_counter = 0;
                resLocAnimation = frame_upgrade_4;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            matrixStackIn.func_227862_a_(0.75f, 0.75f, 0.75f);
            matrixStackIn.func_227861_a_((double)-0.1f, (double)0.45f, (double)0.1f);
            switch (tet.getUpgradeRotation()) {
                case 0: {
                    matrixStackIn.func_227863_a_(new Quaternion(0.0f, 0.0f, 0.0f, true));
                    matrixStackIn.func_227861_a_(0.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    matrixStackIn.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                    matrixStackIn.func_227861_a_((double)-0.1f, 0.0, 0.0);
                    break;
                }
                case 2: {
                    matrixStackIn.func_227863_a_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                    matrixStackIn.func_227861_a_((double)-0.2f, 0.0, (double)0.2f);
                    break;
                }
                case 3: {
                    matrixStackIn.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.2f);
                    break;
                }
                default: {
                    matrixStackIn.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                    matrixStackIn.func_227861_a_(0.0, 0.0, (double)0.2f);
                }
            }
            modeltelepad.renderUpgrade(matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)resLocAnimation)), combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        if (tet.hasRedstoneUpgrade()) {
            this.renderTorch(tet, matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)PlayerContainer.field_226615_c_)), combinedOverlayIn, -0.4375, -0.25, 0.4375);
            this.renderTorch(tet, matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)PlayerContainer.field_226615_c_)), combinedOverlayIn, -0.4375, -0.25, -0.4375);
            this.renderTorch(tet, matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)PlayerContainer.field_226615_c_)), combinedOverlayIn, 0.4375, -0.25, 0.4375);
            this.renderTorch(tet, matrixStackIn, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)PlayerContainer.field_226615_c_)), combinedOverlayIn, 0.4375, -0.25, -0.4375);
        }
    }

    private void renderTorch(TileEntityTelepad te, MatrixStack stack, IVertexBuilder builder, int combinedOverlay, double offsetX, double offsetY, double offsetZ) {
        stack.func_227860_a_();
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
        World world = te.func_145831_w();
        BlockState state = (BlockState)Blocks.field_150429_aA.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(te.isPowered()));
        stack.func_227861_a_(offsetX, offsetY, offsetZ);
        IBakedModel model = blockrendererdispatcher.func_184389_a(state);
        blockrendererdispatcher.func_175019_b().renderModel((IBlockDisplayReader)world, model, state, te.func_174877_v(), stack, builder, false, world.field_73012_v, 0L, combinedOverlay, (IModelData)EmptyModelData.INSTANCE);
        stack.func_227865_b_();
    }

    public void renderPad(MatrixStack stack, Color colorFrame, Color colorBase, IRenderTypeBuffer bufferIn, int packedLightIn, int packedOverlayIn) {
        float f2 = 1.5f;
        stack.func_227862_a_(f2, f2, f2);
        stack.func_227860_a_();
        modeltelepad.renderArrows(stack, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)base)), packedLightIn, packedOverlayIn, (float)colorBase.getRed() / 255.0f, (float)colorBase.getGreen() / 255.0f, (float)colorBase.getBlue() / 255.0f);
        stack.func_227865_b_();
        stack.func_227860_a_();
        modeltelepad.renderLegs(stack, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)pads)), packedLightIn, packedOverlayIn, (float)colorFrame.getRed() / 255.0f, (float)colorFrame.getGreen() / 255.0f, (float)colorFrame.getBlue() / 255.0f);
        stack.func_227863_a_(new Quaternion(0.0f, 90.0f, 0.0f, true));
        modeltelepad.renderLegs(stack, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)pads)), packedLightIn, packedOverlayIn, (float)colorFrame.getRed() / 255.0f, (float)colorFrame.getGreen() / 255.0f, (float)colorFrame.getBlue() / 255.0f);
        stack.func_227863_a_(new Quaternion(0.0f, -90.0f, 0.0f, true));
        stack.func_227865_b_();
        stack.func_227860_a_();
        modeltelepad.renderFrame(stack, bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)frame)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f);
        stack.func_227865_b_();
    }

    static {
        resourcePath = "telepads:textures/entity/tile/";
        base = new ResourceLocation(resourcePath + "telepad_base.png");
        pads = new ResourceLocation(resourcePath + "telepad_pads.png");
        frame = new ResourceLocation(resourcePath + "telepad_frame.png");
        frame_upgrade = new ResourceLocation(resourcePath + "telepad_dimension_upgrade.png");
        frame_upgrade_2 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_2.png");
        frame_upgrade_3 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_3.png");
        frame_upgrade_4 = new ResourceLocation(resourcePath + "telepad_dimension_upgrade_4.png");
    }
}

