/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketRequestNamingScreen;
import subaraki.telepads.registry.TelepadBlockEntities;
import subaraki.telepads.registry.TelepadBlocks;
import subaraki.telepads.registry.TelepadItems;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class BlockTelepad
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final AABB AABB = new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final VoxelShape VOX = Shapes.m_83064_((AABB)AABB);
    private static final VoxelShape shape = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0));
    private static final VoxelShape shape_n = Shapes.m_83064_((AABB)new AABB(0.32, 0.0, -0.22, 0.68, 0.15, 0.0));
    private static final VoxelShape shape_s = Shapes.m_83064_((AABB)new AABB(0.32, 0.0, 1.0, 0.68, 0.15, 1.22));
    private static final VoxelShape shape_e = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.32, 1.22, 0.15, 0.68));
    private static final VoxelShape shape_w = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.32, -0.22, 0.15, 0.68));
    private static final VoxelShape SHAPE_VOX = Shapes.m_83124_((VoxelShape)shape_w, (VoxelShape[])new VoxelShape[]{shape_e, shape_s, shape_n, shape});
    private static final BlockBehaviour.Properties block_properties = BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(5.0f, Float.MAX_VALUE).m_60918_(SoundType.f_56744_).m_60999_().m_60955_();
    private final TranslatableComponent text_public_rod = new TranslatableComponent("block.info.rod");
    private final TranslatableComponent text_public_rod_private = new TranslatableComponent("block.info.rod.private");
    private final TranslatableComponent text_public_rod_public = new TranslatableComponent("block.info.rod.public");
    private final TranslatableComponent text__cycle_rod_normal = new TranslatableComponent("block.info.cycle.normal");
    private final TranslatableComponent text__cycle_rod = new TranslatableComponent("block.info.cycle");
    private final TranslatableComponent cycle_add_success = new TranslatableComponent("block.info.add.succes");
    private final TranslatableComponent cycle_add_remove = new TranslatableComponent("block.info.add.fail");
    private final TranslatableComponent cycle_add_fail = new TranslatableComponent("block.info.add.remove");

    public BlockTelepad() {
        super(block_properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(BlockState p_200123_1_, BlockGetter p_200123_2_, BlockPos p_200123_3_) {
        return false;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direciton, BlockState toState, LevelAccessor levelAccessor, BlockPos pos, BlockPos newPos) {
        if (((Boolean)this.m_7374_().m_49966_().m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_6217_().m_5945_(pos, (Object)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return this.m_7374_().m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_VOX;
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VOX;
    }

    @Deprecated
    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return SHAPE_VOX;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public int m_7753_(BlockState p_60585_, BlockGetter p_60586_, BlockPos p_60587_) {
        return 1;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityTelepad(pos, state);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TelepadEntry entry;
        if (world.m_5776_()) {
            return InteractionResult.FAIL;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_41619_()) {
            Item heldItem = heldStack.m_41720_();
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof TileEntityTelepad) {
                DyeColor edc;
                MutableComponent text;
                TileEntityTelepad tileEntityTelepad = (TileEntityTelepad)blockEntity;
                TelepadEntry entry2 = WorldDataHandler.get((LevelAccessor)world).getEntryForLocation(pos, (ResourceKey<Level>)world.m_46472_());
                if (entry2 != null) {
                    if (heldItem.equals(TelepadItems.TRANSMITTER.get()) && !entry2.hasTransmitter) {
                        tileEntityTelepad.addDimensionUpgrade(true);
                        world.m_7260_(pos, world.m_8055_(pos), this.m_49966_(), 3);
                        entry2.hasTransmitter = true;
                        heldStack.m_41774_(player.m_7500_() ? 0 : 1);
                        WorldDataHandler.get((LevelAccessor)world).updateEntry(entry2);
                    }
                    if (heldItem.equals(TelepadItems.CREATIVE_ROD_PUBLIC.get())) {
                        tileEntityTelepad.toggleAcces();
                        world.m_7260_(pos, world.m_8055_(pos), this.m_49966_(), 3);
                        entry2.setPublic(tileEntityTelepad.isPublic());
                        MutableComponent private_rod = this.text_public_rod.m_6881_().m_130946_(" ").m_7220_((Component)this.text_public_rod_private);
                        MutableComponent public_rod = this.text_public_rod.m_6881_().m_130946_(" ").m_7220_((Component)this.text_public_rod_public);
                        text = tileEntityTelepad.isPublic() ? public_rod : private_rod;
                        player.m_6352_((Component)text, player.m_142081_());
                        WorldDataHandler.get((LevelAccessor)world).updateEntry(entry2);
                    }
                }
                if (heldItem.equals(TelepadItems.TOGGLER.get()) && !tileEntityTelepad.hasRedstoneUpgrade()) {
                    tileEntityTelepad.addRedstoneUpgrade();
                    world.m_7260_(pos, world.m_8055_(pos), this.m_49966_(), 3);
                    this.m_6861_(this.m_7374_().m_49966_(), world, pos, (Block)this, pos, false);
                    heldStack.m_41774_(player.m_7500_() ? 0 : 1);
                }
                if (heldItem.equals(TelepadItems.CREATIVE_ROD.get())) {
                    tileEntityTelepad.rotateCoordinateHandlerIndex();
                    int index = tileEntityTelepad.getCoordinateHandlerIndex();
                    if (index > -1) {
                        text = ConfigData.tp_locations;
                        if (text instanceof String[]) {
                            String[] tpl = (String[])text;
                            CoordinateHandler ch = new CoordinateHandler((ServerLevel)world, tpl[index]);
                            String name = ch.getName();
                            MutableComponent msg = this.text__cycle_rod.m_6881_().m_130946_(name);
                            player.m_6352_((Component)msg, player.m_142081_());
                            world.m_7260_(pos, world.m_8055_(pos), this.m_49966_(), 3);
                            this.m_6861_(this.m_7374_().m_49966_(), world, pos, (Block)this, pos, false);
                        }
                    } else {
                        player.m_6352_((Component)this.text__cycle_rod_normal, player.m_142081_());
                    }
                }
                if (heldItem instanceof DyeItem && (edc = DyeColor.getColor((ItemStack)heldStack)) != null) {
                    float red = edc.m_41068_()[0];
                    float green = edc.m_41068_()[1];
                    float blue = edc.m_41068_()[2];
                    int color = (int)(red * 255.0f);
                    color = (color << 8) + (int)(green * 255.0f);
                    color = (color << 8) + (int)(blue * 255.0f);
                    if (tileEntityTelepad.getColorFeet() == TileEntityTelepad.COLOR_FEET_BASE) {
                        tileEntityTelepad.setFeetColor(color);
                    } else if (tileEntityTelepad.getColorArrow() == TileEntityTelepad.COLOR_ARROW_BASE) {
                        tileEntityTelepad.setArrowColor(color);
                    }
                    tileEntityTelepad.m_6596_();
                    world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
                    if (!player.m_7500_()) {
                        heldStack.m_41774_(1);
                    }
                }
                if (heldItem.equals(Items.f_42447_)) {
                    boolean hasWashed = false;
                    if (tileEntityTelepad.getColorFeet() != TileEntityTelepad.COLOR_FEET_BASE) {
                        this.wash(tileEntityTelepad.getColorFeet(), world, pos);
                        tileEntityTelepad.setFeetColor(TileEntityTelepad.COLOR_FEET_BASE);
                        hasWashed = true;
                    }
                    if (tileEntityTelepad.getColorArrow() != TileEntityTelepad.COLOR_ARROW_BASE) {
                        this.wash(tileEntityTelepad.getColorArrow(), world, pos);
                        tileEntityTelepad.setArrowColor(TileEntityTelepad.COLOR_ARROW_BASE);
                        hasWashed = true;
                    }
                    if (!player.m_7500_() && hasWashed) {
                        world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
                        player.m_21008_(hand, heldStack.getContainerItem());
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (player.m_6144_() && world.m_7702_(pos) instanceof TileEntityTelepad && (entry = WorldDataHandler.get((LevelAccessor)world).getEntryForLocation(pos, (ResourceKey<Level>)world.m_46472_())) != null && InteractionHand.MAIN_HAND.equals((Object)hand)) {
            if (!entry.canUse(player.m_142081_())) {
                Style style = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
                MutableComponent msg = this.cycle_add_success.m_6881_().m_130946_(entry.entryName);
                player.m_6352_((Component)msg.m_6270_(style), player.m_142081_());
                entry.addUser(player.m_142081_());
                return InteractionResult.SUCCESS;
            }
            if (!entry.isPublic) {
                Style style = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
                MutableComponent msg = this.cycle_add_remove.m_6881_().m_130946_(entry.entryName).m_6270_(style);
                player.m_6352_((Component)msg, player.m_142081_());
                entry.removeUser(player.m_142081_());
                return InteractionResult.SUCCESS;
            }
            MutableComponent msg = this.cycle_add_fail.m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
            player.m_6352_((Component)msg, player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private void wash(int color, Level world, BlockPos pos) {
        DyeColor edc = DyeColor.WHITE;
        for (DyeColor dye : DyeColor.values()) {
            if (dye.m_41068_()[0] != (float)((color & 0xFF0000) >> 16) / 255.0f || dye.m_41068_()[1] != (float)((color & 0xFF00) >> 8) / 255.0f || dye.m_41068_()[2] != (float)(color & 0xFF) / 255.0f) continue;
            edc = dye;
        }
        ItemStack stack = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)edc), 1);
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity te = world.m_7702_(pos);
        BlockEntity blockEntity = te;
        if (!(blockEntity instanceof TileEntityTelepad)) {
            return;
        }
        TileEntityTelepad tileEntityTelepad = (TileEntityTelepad)blockEntity;
        if (!tileEntityTelepad.hasRedstoneUpgrade()) {
            return;
        }
        Direction[] facesThatCanPower = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};
        boolean isPowered = false;
        for (Direction face : facesThatCanPower) {
            if (!world.m_8055_(pos.m_142300_(face)).m_60803_()) continue;
            int power = world.m_8055_(pos.m_142300_(face)).m_60775_((BlockGetter)world, pos, face);
            int weakPower = world.m_8055_(pos.m_142300_(face)).m_60746_((BlockGetter)world, pos, face);
            if (power <= 0 && weakPower <= 0) continue;
            isPowered = true;
            break;
        }
        tileEntityTelepad.setPowered(isPowered);
        tileEntityTelepad.m_6596_();
        world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
        WorldDataHandler wdh = WorldDataHandler.get((LevelAccessor)world);
        TelepadEntry entry = wdh.getEntryForLocation(pos, (ResourceKey<Level>)world.m_46472_());
        entry.setPowered(isPowered);
        wdh.updateEntry(entry);
        wdh.m_77762_();
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad) {
            LivingEntity livingEntity;
            TileEntityTelepad tileEntityTelepad = (TileEntityTelepad)blockEntity;
            if (!world.f_46443_ && (livingEntity = placer) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                tileEntityTelepad.setDimension((ResourceKey<Level>)world.m_46472_());
                if (stack.m_41782_() && stack.m_41783_() != null) {
                    if (stack.m_41783_().m_128441_("colorFrame")) {
                        tileEntityTelepad.setFeetColor(stack.m_41783_().m_128451_("colorFrame"));
                    }
                    if (stack.m_41783_().m_128441_("colorBase")) {
                        tileEntityTelepad.setArrowColor(stack.m_41783_().m_128451_("colorBase"));
                    }
                }
                tileEntityTelepad.m_6596_();
                world.m_7260_(pos, world.m_8055_(pos), world.m_8055_(pos), 3);
                world.m_151523_((BlockEntity)tileEntityTelepad);
                NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new CPacketRequestNamingScreen(pos));
            }
        }
    }

    public boolean removedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad) {
            TelepadEntry entry;
            TileEntityTelepad tileEntityTelepad = (TileEntityTelepad)blockEntity;
            if (!world.f_46443_ && (entry = WorldDataHandler.get((LevelAccessor)world).getEntryForLocation(pos, (ResourceKey<Level>)world.m_46472_())) != null) {
                entry.isMissingFromLocation = true;
                this.dropPad(world, tileEntityTelepad, pos);
                if (tileEntityTelepad.hasDimensionUpgrade()) {
                    world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TelepadItems.TRANSMITTER.get(), 1)));
                }
                if (tileEntityTelepad.hasRedstoneUpgrade()) {
                    world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TelepadItems.TOGGLER.get(), 1)));
                }
                return world.m_7471_(pos, false);
            }
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    private void dropPad(Level world, TileEntityTelepad telepad, BlockPos pos) {
        ItemEntity itemEntity = new ItemEntity(EntityType.f_20461_, world);
        itemEntity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ItemStack stack = new ItemStack((ItemLike)TelepadBlocks.TELEPAD_BLOCK.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("colorBase", telepad.getColorArrow());
        nbt.m_128405_("colorFrame", telepad.getColorFeet());
        stack.m_41751_(nbt);
        itemEntity.m_32045_(stack);
        world.m_7967_((Entity)itemEntity);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return entity instanceof Player;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        TileEntityTelepad tileEntityTelepad;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad && !(tileEntityTelepad = (TileEntityTelepad)blockEntity).isPowered()) {
            int maxParticleCount = tileEntityTelepad.isStandingOnPlatform() ? 15 : 1;
            for (int particleCount = 0; particleCount < maxParticleCount; ++particleCount) {
                if (tileEntityTelepad.getCoordinateHandlerIndex() > -1) {
                    for (int i = -2; i <= 2; ++i) {
                        for (int j = -2; j <= 2; ++j) {
                            if (i > -2 && i < 2 && j == -1) {
                                j = 2;
                            }
                            if (random.nextInt(4) != 0) continue;
                            for (int k = 0; k <= 2; ++k) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, (double)i + random.nextDouble() - 0.5, (double)k - random.nextDouble() - 0.0, (double)j + random.nextDouble() - 0.5);
                            }
                        }
                    }
                    continue;
                }
                double posX = (float)pos.m_123341_() + 0.5f;
                double posY = (float)pos.m_123342_() + random.nextFloat() * 1.5f;
                double posZ = (float)pos.m_123343_() + 0.5f;
                int velocityXOffset = random.nextInt(2) * 2 - 1;
                int velocityZOffset = random.nextInt(2) * 2 - 1;
                double velocityY = ((double)random.nextFloat() - 0.5) * 0.125;
                double velocityX = random.nextFloat() * 1.0f * (float)velocityXOffset;
                double velocityZ = random.nextFloat() * 1.0f * (float)velocityZOffset;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, posX, posY, posZ, velocityX, velocityY, velocityZ);
            }
        }
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        WorldDataHandler wdh;
        TelepadEntry entry;
        super.m_5707_(worldIn, pos, state, player);
        if (!worldIn.m_5776_() && (entry = (wdh = WorldDataHandler.get((LevelAccessor)worldIn)).getEntryForLocation(pos, (ResourceKey<Level>)worldIn.m_46472_())) != null) {
            entry.isMissingFromLocation = true;
        }
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        WorldDataHandler wdh;
        TelepadEntry entry;
        super.onBlockExploded(state, world, pos, explosion);
        if (!world.m_5776_() && (entry = (wdh = WorldDataHandler.get((LevelAccessor)world)).getEntryForLocation(pos, (ResourceKey<Level>)world.m_46472_())) != null) {
            entry.isMissingFromLocation = true;
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> be) {
        if (!level.f_46443_) {
            return be == TelepadBlockEntities.TILE_ENTITY_TELEPAD.get() ? TileEntityTelepad.TICKER : super.m_142354_(level, state, be);
        }
        return super.m_142354_(level, state, be);
    }
}

