/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketTeleport;
import subaraki.telepads.utility.ClientReferences;
import subaraki.telepads.utility.TelepadEntry;

public class TeleportScreen
extends Screen {
    protected final List<AbstractWidget> unscrollables = Lists.newArrayList();
    final int START_X = 10;
    final int START_Y = 30;
    final int GAP = 5;
    private final LinkedList<TelepadEntry> entries = new LinkedList();
    private final boolean is_transmitter_pad;
    protected List<ResourceKey<Level>> dimensions_visited = Lists.newArrayList();
    EditBox dimension_indicator;
    private ResourceKey<Level> lookup_dim_id = Level.f_46428_;
    private int scrollbarscroll = 0;
    private int tuner_counter = 0;

    public TeleportScreen(boolean is_transmitter_pad) {
        super((Component)new TranslatableComponent("telepad.gui"));
        this.is_transmitter_pad = is_transmitter_pad;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.lookup_dim_id = this.f_96541_.f_91073_.m_46472_();
        this.scrollbarscroll = 0;
        this.dimension_indicator = new EditBox(this.f_96547_, this.f_96541_.m_91268_().m_85445_() / 2 - 75, 5, 150, 20, (Component)new TranslatableComponent("indicator"));
        this.dimension_indicator.m_94144_(this.lookup_dim_id.m_135782_().m_135815_());
        this.initialize_pages();
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        stack.m_85836_();
        RenderSystem.m_157427_(GameRenderer::m_172755_);
        MultiBufferSource.BufferSource source = this.f_96541_.m_91269_().m_110104_();
        this.renderCube(stack, source.m_6299_(RenderType.m_173239_()));
        source.m_109911_();
        RenderSystem.m_69472_();
        stack.m_85849_();
        TeleportScreen.m_93172_((PoseStack)stack, (int)10, (int)30, (int)(this.f_96543_ - 10), (int)(this.f_96544_ - 30), (int)0x55444444);
        Window window = this.f_96541_.m_91268_();
        int scale = (int)window.m_85449_();
        RenderSystem.m_69488_((int)(10 * scale), (int)(30 * scale), (int)(this.f_96543_ * scale), (int)((this.f_96544_ - 60) * scale));
        super.m_6305_(stack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69471_();
        if (!this.f_169369_.isEmpty()) {
            this.drawFakeScrollBar(stack);
        }
        this.dimension_indicator.m_6305_(stack, mouseX, mouseY, partialTicks);
        this.unscrollables.forEach(b -> b.m_6305_(stack, mouseX, mouseY, partialTicks));
    }

    public boolean m_6050_(double mouseX, double mouseY, double mouseScroll) {
        int index = this.f_169369_.size() > 0 ? this.f_169369_.size() - 1 : 0;
        Object e = this.f_169369_.get(index);
        if (e instanceof AbstractWidget) {
            AbstractWidget last = (AbstractWidget)e;
            e = this.f_169369_.get(0);
            if (e instanceof AbstractWidget) {
                AbstractWidget first = (AbstractWidget)e;
                int forsee_bottom_limit = (int)((double)(last.f_93621_ + last.m_93694_()) + mouseScroll * 16.0);
                int bottom_limit = this.f_96544_ - 30 - last.m_93694_();
                int forsee_top_limit = (int)((double)(first.f_93621_ - 15) + mouseScroll * 16.0);
                int top_limit = 35;
                if (mouseScroll < 0.0 && forsee_bottom_limit < bottom_limit) {
                    return super.m_6050_(mouseX, mouseY, mouseScroll);
                }
                if (mouseScroll > 0.0 && forsee_top_limit > top_limit) {
                    return super.m_6050_(mouseX, mouseY, mouseScroll);
                }
                this.move(mouseScroll);
            }
        }
        return super.m_6050_(mouseX, mouseY, mouseScroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int buttonID, double amountX, double amountY) {
        return super.m_7979_(mouseX, mouseY, buttonID, amountX, amountY);
    }

    public void m_7861_() {
        super.m_7861_();
    }

    private void drawFakeScrollBar(PoseStack stack) {
        Object e = this.f_169369_.get(this.f_169369_.size() - 1);
        if (e instanceof AbstractWidget) {
            AbstractWidget last = (AbstractWidget)e;
            e = this.f_169369_.get(0);
            if (e instanceof AbstractWidget) {
                AbstractWidget first = (AbstractWidget)e;
                int top = first.f_93621_;
                float containerSize = this.f_96544_ - 60;
                int bot = last.f_93621_ + last.m_93694_();
                float totalSize = bot - top + 5;
                float percent = containerSize / totalSize * 100.0f;
                if (percent < 100.0f) {
                    float sizeBar = containerSize / 100.0f * percent;
                    float relativeScroll = (float)this.scrollbarscroll / 100.0f * percent;
                    this.m_93179_(stack, this.f_96543_ - 10, 30, this.f_96543_, 30 + (int)containerSize, Integer.MIN_VALUE, -2145246686);
                    this.m_93179_(stack, this.f_96543_ - 10, 30 + (int)relativeScroll, this.f_96543_, 30 + (int)relativeScroll + (int)sizeBar, -2130706433, -2145246686);
                }
            }
        }
    }

    private void move(double scroll) {
        this.scrollbarscroll = (int)((double)this.scrollbarscroll - scroll * 16.0);
        for (Widget widget : this.f_169369_) {
            Widget widget2 = widget;
            if (!(widget2 instanceof AbstractWidget)) continue;
            AbstractWidget button = (AbstractWidget)widget2;
            button.f_93621_ = (int)((double)button.f_93621_ + scroll * 16.0);
        }
    }

    private void setup_dimension_page() {
        int max_collumns;
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
            for (TelepadEntry entry : data.getEntries()) {
                if (!entry.dimensionID.equals(this.lookup_dim_id)) continue;
                this.entries.add(entry);
            }
        });
        int increment = max_collumns = Minecraft.m_91087_().m_91268_().m_85445_() / 130;
        int central_offset = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - max_collumns * 120 / 2;
        for (TelepadEntry entry : this.entries) {
            int extra_y = increment / max_collumns;
            int extra_x = increment % max_collumns;
            ChatFormatting color = entry.isMissingFromLocation ? ChatFormatting.GRAY : (entry.isPowered ? ChatFormatting.DARK_RED : (entry.isPublic ? ChatFormatting.LIGHT_PURPLE : (entry.hasTransmitter ? ChatFormatting.GREEN : ChatFormatting.WHITE)));
            this.m_142416_((GuiEventListener)new Button(central_offset + 5 + extra_x * 120, 15 + extra_y * 25, 110, 20, (Component)new TextComponent(entry.entryName).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)color)).m_131136_(Boolean.valueOf(entry.position.equals((Object)ClientReferences.getClientPlayer().m_142538_())))), button -> {
                if (entry.isMissingFromLocation) {
                    this.m_7861_();
                    this.m_7379_();
                    ClientReferences.openMissingScreen(entry);
                } else {
                    NetworkHandler.NETWORK.sendToServer((Object)new SPacketTeleport(ClientReferences.getClientPlayer().m_142538_(), entry, false));
                    this.m_7861_();
                    this.m_7379_();
                }
            }));
            ++increment;
        }
    }

    private void add_paging_buttons() {
        while (this.dimensions_visited.get(this.tuner_counter) != this.lookup_dim_id) {
            ++this.tuner_counter;
        }
        int centerx = Minecraft.m_91087_().m_91268_().m_85445_() / 2;
        Button button_left = new Button(centerx - 75 - 25, 5, 20, 20, (Component)new TextComponent("<"), button -> {
            if (this.dimensions_visited.size() > 1) {
                --this.tuner_counter;
                if (this.tuner_counter < 0) {
                    this.tuner_counter = this.dimensions_visited.size() - 1;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.m_94144_(this.lookup_dim_id.m_135782_().m_135815_());
            this.initialize_pages();
        });
        Button button_right = new Button(centerx + 75 + 5, 5, 20, 20, (Component)new TextComponent(">"), button -> {
            if (this.dimensions_visited.size() > 1) {
                ++this.tuner_counter;
                if (this.tuner_counter >= this.dimensions_visited.size()) {
                    this.tuner_counter = 0;
                }
            }
            this.lookup_dim_id = this.dimensions_visited.get(this.tuner_counter);
            this.dimension_indicator.m_94144_(this.lookup_dim_id.m_135782_().m_135815_());
            this.initialize_pages();
        });
        this.unscrollables.add((AbstractWidget)button_left);
        this.unscrollables.add((AbstractWidget)button_right);
        this.m_7787_((GuiEventListener)button_left);
        this.m_7787_((GuiEventListener)button_right);
    }

    private void initialize_pages() {
        this.m_169413_();
        this.entries.clear();
        this.unscrollables.clear();
        this.dimensions_visited.clear();
        this.setup_dimension_list();
        this.setup_dimension_page();
        if (this.is_transmitter_pad) {
            this.add_paging_buttons();
        }
    }

    private void setup_dimension_list() {
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> data.getEntries().forEach(entry -> {
            if (!this.dimensions_visited.contains(entry.dimensionID)) {
                this.dimensions_visited.add(entry.dimensionID);
            }
        }));
    }

    private void renderCube(PoseStack stack, VertexConsumer vertexConsumer) {
        float width = Minecraft.m_91087_().m_91268_().m_85445_();
        float height = Minecraft.m_91087_().m_91268_().m_85446_();
        float max = Math.max(width, height);
        this.renderFace(stack, vertexConsumer, 0.0f, max, max, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    private void renderFace(PoseStack stack, VertexConsumer vertexConsumer, float x0, float x1, float y0, float y1, float z1, float z2, float z3, float z4) {
        Matrix4f matrix4f = stack.m_85850_().m_85861_();
        vertexConsumer.m_85982_(matrix4f, x0, y0, z1).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y0, z2).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y1, z3).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x0, y1, z4).m_5752_();
    }
}

