/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fmllegacy.network.PacketDistributor;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketRequestTeleportScreen;
import subaraki.telepads.registry.TelepadBlockEntities;
import subaraki.telepads.registry.TelepadBlocks;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class TileEntityTelepad
extends BlockEntity {
    public static final BlockEntityTicker<TileEntityTelepad> TICKER = (level, pos, state, be) -> be.tick();
    public static final int COLOR_FEET_BASE = new Color(26, 246, 172).getRGB();
    public static final int COLOR_ARROW_BASE = new Color(243, 89, 233).getRGB();
    private ResourceKey<Level> dimension;
    private int colorFrame = COLOR_FEET_BASE;
    private int colorBase = COLOR_ARROW_BASE;
    private int upgradeRotation = 0;
    private boolean hasDimensionUpgrade = false;
    private boolean hasRedstoneUpgrade = false;
    private boolean isPowered = false;
    private boolean isPublic = false;
    private boolean isStandingOnPlatform;
    private int coordinate_handler_index = -1;

    public TileEntityTelepad(BlockPos pos, BlockState state) {
        super((BlockEntityType)TelepadBlockEntities.TILE_ENTITY_TELEPAD.get(), pos, state);
    }

    public ClientboundBlockEntityDataPacket m_7033_() {
        return new ClientboundBlockEntityDataPacket(this.m_58899_(), 0, this.m_6945_(new CompoundTag()));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    public CompoundTag m_5995_() {
        return this.m_6945_(new CompoundTag());
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        String dim = compound.m_128461_("dimension");
        this.hasDimensionUpgrade = compound.m_128471_("upgrade_dimension");
        this.hasRedstoneUpgrade = compound.m_128471_("upgrade_redstone");
        this.isPowered = compound.m_128471_("is_powered");
        this.colorBase = compound.m_128451_("colorBase");
        this.colorFrame = compound.m_128451_("colorFrame");
        this.upgradeRotation = compound.m_128451_("upgradeRotation");
        this.isStandingOnPlatform = compound.m_128471_("standingon");
        this.coordinate_handler_index = compound.m_128451_("mod_tp");
        this.isPublic = compound.m_128471_("public");
        if (!dim.isEmpty()) {
            this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dim));
        }
    }

    public CompoundTag m_6945_(CompoundTag compound) {
        super.m_6945_(compound);
        compound.m_128359_("dimension", this.dimension.m_135782_().toString());
        compound.m_128379_("upgrade_dimension", this.hasDimensionUpgrade);
        compound.m_128379_("upgrade_redstone", this.hasRedstoneUpgrade);
        compound.m_128379_("is_powered", this.isPowered);
        compound.m_128405_("colorBase", this.colorBase);
        compound.m_128405_("colorFrame", this.colorFrame);
        compound.m_128405_("upgradeRotation", this.upgradeRotation);
        compound.m_128379_("standingon", this.isStandingOnPlatform);
        compound.m_128405_("mod_tp", this.coordinate_handler_index);
        compound.m_128379_("public", this.isPublic);
        return compound;
    }

    public void tick() {
        if (this.isPowered || this.f_58857_ == null) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            AABB aabb = new AABB(this.m_58899_());
            List list = this.f_58857_.m_45976_(ServerPlayer.class, aabb);
            if (!list.isEmpty()) {
                this.setPlatform(true);
                for (ServerPlayer playerOnPad : list) {
                    TelepadData.get((Player)playerOnPad).ifPresent(data -> {
                        if (data.getRequestTeleportScreen()) {
                            data.setRequestTeleportScreen(false);
                            TelepadEntry telepad = WorldDataHandler.get((LevelAccessor)this.m_58904_()).getEntryForLocation(this.m_58899_(), this.dimension);
                            boolean is_transmitter = telepad != null && telepad.hasTransmitter;
                            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> playerOnPad), (Object)new CPacketRequestTeleportScreen(data.getEntries(), data.getWhitelist().values(), is_transmitter));
                            return;
                        }
                        if (data.getCounter() > 0 && !data.isInTeleportGui()) {
                            --data.counter;
                        } else if (data.getCounter() == 0 && !data.isInTeleportGui()) {
                            if (this.f_58857_.m_46472_().equals((Object)Level.f_46430_) && ConfigData.allowDragonBlocking && this.f_58857_ instanceof ServerLevel && !((ServerLevel)this.f_58857_).m_8857_().isEmpty()) {
                                data.setCounter(TelepadData.getMaxTime());
                                playerOnPad.m_6352_((Component)new TranslatableComponent("dragon.obstructs").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_PURPLE)).m_131155_(Boolean.valueOf(true))), playerOnPad.m_142081_());
                                return;
                            }
                            if (this.getCoordinateHandlerIndex() > -1) {
                                int index = this.getCoordinateHandlerIndex();
                                Object[] tpl$temp = ConfigData.tp_locations;
                                if (tpl$temp instanceof String[]) {
                                    String[] tpl = (String[])tpl$temp;
                                    CoordinateHandler coords = new CoordinateHandler((ServerLevel)this.f_58857_, tpl[index]);
                                    ResourceLocation dimension = coords.getDimension();
                                    if (!playerOnPad.f_19853_.m_46472_().m_135782_().equals((Object)dimension)) {
                                        MinecraftServer server = playerOnPad.m_20194_();
                                        ResourceKey dim_key = null;
                                        if (server != null) {
                                            for (ServerLevel dim : server.m_129785_()) {
                                                if (!dim.m_46472_().m_135782_().equals((Object)dimension)) continue;
                                                dim_key = dim.m_46472_();
                                            }
                                        }
                                        if (dim_key == null) {
                                            return;
                                        }
                                        ServerLevel worldDestination = server.m_129880_(this.f_58857_.m_46472_());
                                        BlockPos pos = coords.getPosition((Level)worldDestination);
                                        Teleport.teleportEntityToDimension(playerOnPad, pos, dim_key);
                                    } else {
                                        BlockPos pos = coords.getPosition(this.m_58904_());
                                        Teleport.teleportEntityInsideSameDimension((Entity)playerOnPad, pos);
                                    }
                                }
                            } else {
                                data.setInTeleportGui(true);
                                data.setCounter(TelepadData.getMaxTime());
                                this.activateTelepadGui(playerOnPad);
                            }
                        }
                    });
                }
            } else {
                this.setPlatform(false);
            }
        }
    }

    public void setPlatform(boolean onPlatform) {
        if (this.f_58857_ != null) {
            this.isStandingOnPlatform = onPlatform;
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.m_58899_()), ((Block)TelepadBlocks.TELEPAD_BLOCK.get()).m_49966_(), 3);
        }
    }

    private void activateTelepadGui(ServerPlayer player) {
        TelepadData.get((Player)player).ifPresent(data -> {
            ServerLevel world = player.m_9236_();
            WorldDataHandler save = WorldDataHandler.get((LevelAccessor)world);
            List<TelepadEntry> allTelepads = save.getEntries();
            data.getEntries().clear();
            allTelepads.stream().filter(entry -> entry.canUse(player.m_142081_())).forEach(data::addEntry);
            data.setRequestTeleportScreen(true);
        });
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceKey<Level> dimensionID) {
        this.dimension = dimensionID;
    }

    public void setFeetColor(int rgb) {
        this.colorFrame = rgb;
    }

    public void setArrowColor(int rgb) {
        this.colorBase = rgb;
    }

    public int getColorFeet() {
        return this.colorFrame;
    }

    public int getColorArrow() {
        return this.colorBase;
    }

    public boolean hasDimensionUpgrade() {
        return this.hasDimensionUpgrade;
    }

    public void addDimensionUpgrade(boolean allowed) {
        this.upgradeRotation = allowed ? new Random().nextInt(4) : 0;
        this.hasDimensionUpgrade = true;
    }

    public int getUpgradeRotation() {
        return this.upgradeRotation;
    }

    public boolean hasRedstoneUpgrade() {
        return this.hasRedstoneUpgrade;
    }

    public void addRedstoneUpgrade() {
        this.hasRedstoneUpgrade = true;
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public void rotateCoordinateHandlerIndex() {
        ++this.coordinate_handler_index;
        if (this.coordinate_handler_index >= ConfigData.tp_locations.length) {
            this.coordinate_handler_index = -1;
        }
    }

    public int getCoordinateHandlerIndex() {
        return this.coordinate_handler_index;
    }

    public boolean isStandingOnPlatform() {
        return this.isStandingOnPlatform;
    }

    public void toggleAcces() {
        boolean flag = !this.isPublic;
        TelepadEntry tpe = WorldDataHandler.get((LevelAccessor)this.m_58904_()).getEntryForLocation(this.m_58899_(), this.getDimension());
        tpe.setPublic(flag);
        this.isPublic = flag;
    }

    public boolean isPublic() {
        return this.isPublic;
    }
}

