/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.client.CPacketEditWhiteListEntry;
import subaraki.telepads.network.client.CPacketRequestTeleportScreen;
import subaraki.telepads.screen.MissingEntryScreen;
import subaraki.telepads.screen.NameTelepadScreen;
import subaraki.telepads.screen.TeleportScreen;
import subaraki.telepads.utility.TelepadEntry;

public class ClientReferences {
    public static Player getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static void openNamingScreen(BlockPos pos) {
        Minecraft.m_91087_().m_91152_((Screen)new NameTelepadScreen(pos));
    }

    public static void openMissingScreen(TelepadEntry entry) {
        Minecraft.m_91087_().m_91152_((Screen)new MissingEntryScreen(entry));
    }

    public static Level getClientWorld() {
        return Minecraft.m_91087_().f_91073_;
    }

    public static void displayScreen(Screen screen) {
        Minecraft.m_91087_().m_91152_(screen);
    }

    public static void displayTeleportScreen(boolean has_transmitter) {
        Minecraft.m_91087_().m_91152_((Screen)new TeleportScreen(has_transmitter));
    }

    public static void handlePacket(CPacketRequestTeleportScreen packet) {
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
            data.getEntries().clear();
            if (packet.entries != null && !packet.entries.isEmpty()) {
                packet.entries.forEach(data.getEntries()::add);
            }
            data.setCounter(TelepadData.getMaxTime());
            data.setInTeleportGui(false);
            if (!data.getEntries().isEmpty()) {
                ClientReferences.displayTeleportScreen(packet.has_transmitter);
            }
        });
    }

    public static void handlePacket(CPacketEditWhiteListEntry packet) {
        TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
            if (packet.add) {
                data.addWhiteListEntryClient(packet.name, packet.id);
            } else {
                data.removeWhiteListEntryClient(packet.name);
            }
        });
    }
}

