/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.block;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import subaraki.telepads.block.TelepadBlockInteraction;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.CoordinateHandler;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketRequestNamingScreen;
import subaraki.telepads.registry.TelepadBlockEntities;
import subaraki.telepads.registry.TelepadBlocks;
import subaraki.telepads.registry.TelepadItems;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class BlockTelepad
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final AABB AABB = new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
    protected static final VoxelShape VOX = Shapes.m_83064_((AABB)AABB);
    private static final VoxelShape shape = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0));
    private static final VoxelShape shapeNorth = Shapes.m_83064_((AABB)new AABB(0.32, 0.0, -0.22, 0.68, 0.15, 0.0));
    private static final VoxelShape shapeSouth = Shapes.m_83064_((AABB)new AABB(0.32, 0.0, 1.0, 0.68, 0.15, 1.22));
    private static final VoxelShape shapeEast = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.32, 1.22, 0.15, 0.68));
    private static final VoxelShape shapeWest = Shapes.m_83064_((AABB)new AABB(0.0, 0.0, 0.32, -0.22, 0.15, 0.68));
    private static final VoxelShape FULLSHAPE = Shapes.m_83124_((VoxelShape)shapeWest, (VoxelShape[])new VoxelShape[]{shapeEast, shapeSouth, shapeNorth, shape});
    private static final BlockBehaviour.Properties PROPERTIES = BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(5.0f, Float.MAX_VALUE).m_60918_(SoundType.f_56744_).m_60999_().m_60955_();
    private final TranslatableComponent textPublicRod = new TranslatableComponent("block.info.rod");
    private final TranslatableComponent textPublicRodPrivate = new TranslatableComponent("block.info.rod.private");
    private final TranslatableComponent textPublicRodPublic = new TranslatableComponent("block.info.rod.public");
    private final TranslatableComponent textCycleRodNormal = new TranslatableComponent("block.info.cycle.normal");
    private final TranslatableComponent textCycleRod = new TranslatableComponent("block.info.cycle");
    private final TranslatableComponent cycleAddSuccess = new TranslatableComponent("block.info.add.succes");
    private final TranslatableComponent cycleAddRemove = new TranslatableComponent("block.info.add.fail");
    private final TranslatableComponent cycleAddFail = new TranslatableComponent("block.info.add.remove");

    public BlockTelepad() {
        super(PROPERTIES);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 0;
    }

    public boolean m_7420_(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction direciton, BlockState toState, LevelAccessor levelAccessor, BlockPos pos, BlockPos newPos) {
        if (((Boolean)this.m_7374_().m_49966_().m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return this.m_7374_().m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return super.m_7361_(worldIn, pos, state, fluidStateIn);
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return FULLSHAPE;
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return VOX;
    }

    @Deprecated
    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return FULLSHAPE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public int m_7753_(BlockState state, BlockGetter getter, BlockPos blockPos) {
        return 1;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityTelepad(pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        TelepadEntry entry;
        if (level.m_5776_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (!heldStack.m_41619_()) {
            Item heldItem = heldStack.m_41720_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (!(blockEntity instanceof TileEntityTelepad)) return InteractionResult.SUCCESS;
            TileEntityTelepad telepad = (TileEntityTelepad)blockEntity;
            if (heldItem.equals(TelepadItems.TRANSMITTER.get()) && TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.TRANSMITTER, level, pos, telepad, state, this)) {
                heldStack.m_41774_(player.m_7500_() ? 0 : 1);
            }
            if (heldItem.equals(TelepadItems.PUBLIC_TOGGLE_ROD.get()) && TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.TOGGLE_ACCESS, level, pos, telepad, state, this)) {
                MutableComponent private_rod = this.textPublicRod.m_6881_().m_130946_(" ").m_7220_((Component)this.textPublicRodPrivate);
                MutableComponent public_rod = this.textPublicRod.m_6881_().m_130946_(" ").m_7220_((Component)this.textPublicRodPublic);
                MutableComponent text = telepad.isPublic() ? public_rod : private_rod;
                player.m_6352_((Component)text, player.m_142081_());
            }
            if (heldItem.equals(TelepadItems.TOGGLER.get()) && TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.TOGGLER_UPGRADE, level, pos, telepad, state, this)) {
                heldStack.m_41774_(player.m_7500_() ? 0 : 1);
            }
            if (heldItem.equals(TelepadItems.CYCLE_ROD.get()) && TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.CYCLE, level, pos, telepad, state, this)) {
                int index = telepad.getCoordinateHandlerIndex();
                if (index > -1) {
                    CoordinateHandler handler = new CoordinateHandler((ServerLevel)level, ConfigData.teleportLocations[index]);
                    player.m_6352_((Component)this.textCycleRod.m_6881_().m_130946_(handler.getTelepadName()), player.m_142081_());
                    this.m_6861_(state, level, pos, (Block)this, pos, false);
                } else {
                    player.m_6352_((Component)this.textCycleRodNormal, player.m_142081_());
                }
            }
            if (heldItem instanceof DyeItem) {
                if (!TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.DYE, level, pos, telepad, state, this, DyeColor.getColor((ItemStack)heldStack))) return InteractionResult.PASS;
                if (!player.m_7500_()) {
                    heldStack.m_41774_(1);
                    return InteractionResult.CONSUME;
                }
            }
            if (!heldItem.equals(Items.f_42447_)) return InteractionResult.SUCCESS;
            if (!TelepadBlockInteraction.interact(TelepadBlockInteraction.Action.WASH, level, pos, telepad, state, this)) return InteractionResult.FAIL;
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11778_, SoundSource.BLOCKS, 1.0f, 1.0f, true);
            if (player.m_7500_()) return InteractionResult.SUCCESS;
            player.m_21008_(hand, heldStack.getContainerItem());
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_() || !(level.m_7702_(pos) instanceof TileEntityTelepad) || (entry = WorldDataHandler.get((LevelAccessor)level).getEntryForLocation(pos, (ResourceKey<Level>)level.m_46472_())) == null || !InteractionHand.MAIN_HAND.equals((Object)hand)) return InteractionResult.SUCCESS;
        if (!entry.canUse(player.m_142081_())) {
            Style style = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GREEN));
            MutableComponent msg = this.cycleAddSuccess.m_6881_().m_130946_(entry.entryName);
            player.m_6352_((Component)msg.m_6270_(style), player.m_142081_());
            entry.addUser(player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        if (!entry.isPublic) {
            Style style = Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GOLD));
            MutableComponent msg = this.cycleAddRemove.m_6881_().m_130946_(entry.entryName).m_6270_(style);
            player.m_6352_((Component)msg, player.m_142081_());
            entry.removeUser(player.m_142081_());
            return InteractionResult.SUCCESS;
        }
        MutableComponent msg = this.cycleAddFail.m_6881_().m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)));
        player.m_6352_((Component)msg, player.m_142081_());
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        TileEntityTelepad telepad;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad && (telepad = (TileEntityTelepad)blockEntity).hasRedstoneUpgrade()) {
            boolean isPowered = Arrays.stream(Direction.values()).filter(direction -> !direction.equals((Object)Direction.UP)).anyMatch(face -> {
                BlockState other = level.m_8055_(pos.m_142300_(face));
                return other.m_60803_() && (other.m_60775_((BlockGetter)level, pos, face) > 0 || other.m_60746_((BlockGetter)level, pos, face) > 0);
            });
            WorldDataHandler wdh = WorldDataHandler.get((LevelAccessor)level);
            TelepadEntry entry = wdh.getEntryForLocation(pos, (ResourceKey<Level>)level.m_46472_());
            entry.setPowered(isPowered);
            telepad.setPowered(isPowered);
            level.m_7260_(pos, state, state, 3);
            wdh.updateEntry(entry);
            wdh.m_77762_();
        }
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, world, pos, neighbor);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad) {
            TileEntityTelepad tileEntityTelepad = (TileEntityTelepad)blockEntity;
            if (!world.m_5776_() && placer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)placer;
                if (stack.m_41782_() && stack.m_41783_() != null) {
                    if (stack.m_41783_().m_128441_("colorFrame")) {
                        tileEntityTelepad.setFeetColor(stack.m_41783_().m_128451_("colorFrame"));
                    }
                    if (stack.m_41783_().m_128441_("colorBase")) {
                        tileEntityTelepad.setArrowColor(stack.m_41783_().m_128451_("colorBase"));
                    }
                }
                tileEntityTelepad.setDimension((ResourceKey<Level>)world.m_46472_());
                tileEntityTelepad.m_6596_();
                NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new CPacketRequestNamingScreen(pos));
            }
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TileEntityTelepad) {
            TileEntityTelepad telepad = (TileEntityTelepad)blockEntity;
            this.setMissing(level, pos);
            this.dropPad(level, telepad, pos);
            if (telepad.hasDimensionUpgrade()) {
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TelepadItems.TRANSMITTER.get(), 1)));
            }
            if (telepad.hasRedstoneUpgrade()) {
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TelepadItems.TOGGLER.get(), 1)));
            }
            return level.m_7471_(pos, false);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    private void dropPad(Level world, TileEntityTelepad telepad, BlockPos pos) {
        ItemEntity itemEntity = new ItemEntity(EntityType.f_20461_, world);
        itemEntity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        ItemStack stack = new ItemStack((ItemLike)TelepadBlocks.TELEPAD.get());
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("colorBase", telepad.getColorArrow());
        nbt.m_128405_("colorFrame", telepad.getColorFeet());
        stack.m_41751_(nbt);
        itemEntity.m_32045_(stack);
        world.m_7967_((Entity)itemEntity);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return entity instanceof Player;
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return Float.MAX_VALUE;
    }

    public boolean m_6724_(BlockState state) {
        return true;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        TileEntityTelepad tileEntityTelepad;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileEntityTelepad && !(tileEntityTelepad = (TileEntityTelepad)blockEntity).isPowered()) {
            int maxParticleCount = tileEntityTelepad.isStandingOnPlatform() ? 15 : 1;
            for (int particleCount = 0; particleCount < maxParticleCount; ++particleCount) {
                if (tileEntityTelepad.getCoordinateHandlerIndex() > -1) {
                    for (int i = -2; i <= 2; ++i) {
                        for (int j = -2; j <= 2; ++j) {
                            if (i > -2 && i < 2 && j == -1) {
                                j = 2;
                            }
                            if (random.nextInt(4) != 0) continue;
                            for (int k = 0; k <= 2; ++k) {
                                world.m_7106_((ParticleOptions)ParticleTypes.f_123809_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, (double)i + random.nextDouble() - 0.5, (double)k - random.nextDouble() - 0.0, (double)j + random.nextDouble() - 0.5);
                            }
                        }
                    }
                    continue;
                }
                double posX = (float)pos.m_123341_() + 0.5f;
                double posY = (float)pos.m_123342_() + random.nextFloat() * 1.5f;
                double posZ = (float)pos.m_123343_() + 0.5f;
                int velocityXOffset = random.nextInt(2) * 2 - 1;
                int velocityZOffset = random.nextInt(2) * 2 - 1;
                double velocityY = ((double)random.nextFloat() - 0.5) * 0.125;
                double velocityX = random.nextFloat() * 1.0f * (float)velocityXOffset;
                double velocityZ = random.nextFloat() * 1.0f * (float)velocityZOffset;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123760_, posX, posY, posZ, velocityX, velocityY, velocityZ);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(level, pos, state, player);
        this.setMissing(level, pos);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, level, pos, explosion);
        this.setMissing(level, pos);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> be) {
        if (!level.f_46443_) {
            return be == TelepadBlockEntities.TELEPAD.get() ? TileEntityTelepad.TICKER : super.m_142354_(level, state, be);
        }
        return super.m_142354_(level, state, be);
    }

    private void setMissing(Level level, BlockPos pos) {
        WorldDataHandler wdh;
        TelepadEntry entry;
        if (!level.m_5776_() && (entry = (wdh = WorldDataHandler.get((LevelAccessor)level)).getEntryForLocation(pos, (ResourceKey<Level>)level.m_46472_())) != null) {
            entry.isMissingFromLocation = true;
        }
    }
}

