/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.capability.player;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import subaraki.telepads.capability.player.TelepadCapProvider;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketEditWhiteListEntry;
import subaraki.telepads.utility.TelepadEntry;

public class TelepadData {
    private static final int MAX_TIME = ConfigData.teleprtDelay * 20;
    private final LinkedHashMap<String, UUID> whitelist = new LinkedHashMap();
    public int counter = MAX_TIME;
    private Player player;
    private List<TelepadEntry> entries = new ArrayList<TelepadEntry>();
    private boolean isInTeleportGui;
    private boolean request_teleport = false;

    public static LazyOptional<TelepadData> get(Player player) {
        return player.getCapability(TelepadCapProvider.CAPABILITY, null);
    }

    public static int getMaxTime() {
        return MAX_TIME;
    }

    public void setPlayer(Player newPlayer) {
        this.player = newPlayer;
    }

    public Tag writeData() {
        CompoundTag tag = new CompoundTag();
        ListTag entryList = new ListTag();
        if (this.entries != null && !this.entries.isEmpty()) {
            for (TelepadEntry entry : this.entries) {
                if (entry == null) continue;
                entryList.add((Object)entry.writeToNBT(new CompoundTag()));
            }
        }
        tag.m_128365_("entries", (Tag)entryList);
        ListTag friends = new ListTag();
        this.whitelist.keySet().forEach(name -> {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_(name, this.whitelist.get(name));
            friends.add((Object)nbt);
        });
        tag.m_128365_("list", (Tag)friends);
        return tag;
    }

    public void readData(Tag nbt) {
        CompoundTag tag = (CompoundTag)nbt;
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        ListTag entryTagList = tag.m_128437_("entries", 10);
        for (int tagPos = 0; tagPos < entryTagList.size(); ++tagPos) {
            entryList.add(new TelepadEntry(entryTagList.m_128728_(tagPos)));
        }
        this.entries = entryList;
        ListTag friendList = tag.m_128437_("list", 10);
        friendList.forEach(entry -> ((CompoundTag)entry).m_128431_().forEach(key -> this.whitelist.put((String)key, ((CompoundTag)entry).m_128342_(key))));
    }

    public List<TelepadEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<TelepadEntry>();
        }
        return this.entries;
    }

    public void addEntry(TelepadEntry entry) {
        if (!this.getEntries().contains(entry)) {
            this.getEntries().add(entry);
        }
    }

    public void removeEntry(TelepadEntry entry) {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.position.equals((Object)entry.position) || tpe.dimensionID != entry.dimensionID) continue;
            this.getEntries().remove(tpe);
            break;
        }
    }

    public boolean isInTeleportGui() {
        return this.isInTeleportGui;
    }

    public void setInTeleportGui(boolean isInTeleportGui) {
        this.isInTeleportGui = isInTeleportGui;
    }

    public void overrideEntries(List<TelepadEntry> entries) {
        this.entries = entries;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = counter;
    }

    public void countDown() {
        --this.counter;
    }

    public void removeWhiteListEntryClient(String name) {
        this.whitelist.remove(name);
    }

    public void removeWhiteListEntryServer(String name) {
        if (this.whitelist.containsKey(name)) {
            this.whitelist.remove(name);
            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new CPacketEditWhiteListEntry(name, UUID.randomUUID(), false));
        }
    }

    public void addWhiteListEntryServer(ServerPlayer player) {
        GameProfile profile;
        if (this.isWhiteListNotFull() && !this.whitelist.containsKey((profile = player.m_36316_()).getName())) {
            this.whitelist.put(player.m_36316_().getName(), player.m_36316_().getId());
            NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new CPacketEditWhiteListEntry(profile.getName(), profile.getId(), true));
        }
    }

    public void addWhiteListEntryClient(String name, UUID id) {
        if (this.isWhiteListNotFull() && !this.whitelist.containsKey(name)) {
            this.whitelist.put(name, id);
        }
    }

    public void commandWhitelist(String command) {
        if (this.player.f_19853_.f_46443_) {
            Telepads.log.error("Tried handling commands on the client side.");
            return;
        }
        MinecraftServer serverWorld = this.player.f_19853_.m_142572_();
        if (command.length() > 2) {
            if (command.equalsIgnoreCase("clear")) {
                for (String entry : this.whitelist.keySet()) {
                    this.removeWhiteListEntryServer(entry);
                }
                this.whitelist.clear();
                return;
            }
            String[] command_split = command.split(" ");
            if (command_split.length == 2) {
                String playername = command_split[1];
                switch (command_split[0]) {
                    case "add": {
                        ServerPlayer player = serverWorld.m_6846_().m_11255_(playername);
                        if (player == null) break;
                        this.addWhiteListEntryServer(player);
                        break;
                    }
                    case "remove": {
                        this.removeWhiteListEntryServer(playername);
                    }
                }
            }
        }
    }

    public LinkedHashMap<String, UUID> getWhitelist() {
        return this.whitelist;
    }

    public boolean isWhiteListNotFull() {
        return this.whitelist.size() < 9;
    }

    public boolean getRequestTeleportScreen() {
        return this.request_teleport;
    }

    public void setRequestTeleportScreen(boolean flag) {
        this.request_teleport = flag;
    }
}

