/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigData {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static boolean allowDragonBlocking;
    public static boolean allowAnvilPearls;
    public static boolean allowBeadsUsage;
    public static boolean allowNecklaceUsage;
    public static String[] teleportLocations;
    public static int teleprtDelay;
    public static int expConsume;
    public static int lvlConsume;
    public static boolean allowParticles;

    public static void refreshServer() {
        allowDragonBlocking = (Boolean)ConfigData.SERVER.allowDragonBlocking.get();
        allowAnvilPearls = (Boolean)ConfigData.SERVER.allowAnvilPearls.get();
        allowBeadsUsage = (Boolean)ConfigData.SERVER.allowBeadsUsage.get();
        allowNecklaceUsage = (Boolean)ConfigData.SERVER.allowNecklaceUsage.get();
        expConsume = (Integer)ConfigData.SERVER.exp.get();
        lvlConsume = (Integer)ConfigData.SERVER.lvl.get();
        teleprtDelay = (Integer)ConfigData.SERVER.teleportDelay.get();
        teleportLocations = new String[((List)ConfigData.SERVER.val.get()).size()];
        for (int i = 0; i < ((List)ConfigData.SERVER.val.get()).size(); ++i) {
            ConfigData.teleportLocations[i] = (String)((List)ConfigData.SERVER.val.get()).get(i);
        }
    }

    public static void refreshClient() {
        allowParticles = (Boolean)ConfigData.CLIENT.allowParticles.get();
    }

    static {
        allowDragonBlocking = true;
        allowAnvilPearls = true;
        allowBeadsUsage = true;
        allowNecklaceUsage = true;
        teleportLocations = new String[0];
        teleprtDelay = 3;
        allowParticles = true;
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ClientConfig)specPair.getLeft();
    }

    public static class ServerConfig {
        public final ForgeConfigSpec.BooleanValue allowDragonBlocking;
        public final ForgeConfigSpec.BooleanValue allowAnvilPearls;
        public final ForgeConfigSpec.BooleanValue allowBeadsUsage;
        public final ForgeConfigSpec.BooleanValue allowNecklaceUsage;
        public final ForgeConfigSpec.IntValue exp;
        public final ForgeConfigSpec.IntValue lvl;
        public final ForgeConfigSpec.IntValue teleportDelay;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> val;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Teleporting from and to the End");
            this.allowDragonBlocking = builder.comment("Wether to allow the presence of the Ender Dragon to prevent teleporting away from the End").translation("config.block.dragon").define("Dragon Teleport Block", true);
            builder.pop();
            builder.push("Teleport Items");
            this.allowAnvilPearls = builder.comment("Disable creation of Ender Beads here").translation("config.anvil.allow").define("Allow anvil pearl crafting", true);
            this.allowBeadsUsage = builder.comment("Disable usage of the Ender Beads here").translation("config.beads.allow").define("Allow Ender Bead usage", true);
            this.allowNecklaceUsage = builder.comment("Dsiabe usage of the Ender Necklace here").translation("config.necklace.allow").define("Allow Ender Necklace usage", true);
            builder.pop();
            builder.push("Teleportation Details");
            this.exp = builder.comment("Penalty cost for teleportation, if set to 0, there will be no exp loss. Set level to 0 if you only want to consume an amount of exp.").translation("config.consume.exp").defineInRange("Experience Consumation", 0, 0, 10000);
            this.lvl = builder.comment("Penalty cost for teleportation, if set to 0, there will be no exp loss. set experience to 0 if you want to consume levels.").translation("config.consume.level").defineInRange("Level Consumation", 0, 0, 32);
            this.teleportDelay = builder.comment("Delay, in seconds, on how long a player must wait on the telepad block before the gui opens").translation("config.tele.gui.open").defineInRange("Teleport GUI Delay", 3, 1, 60);
            builder.pop();
            this.val = builder.comment("[x,y,z,dimension,locationName]\n-locations can be defined in multiple ways:\n-exact coordinates : 100/64/100/overworld/Your Own TelepadIdentifier name\n-with margin : -500#1000/64#128/0#500/the_nether/Some Location\n-random : random/random/random/random/My Random Teleporter\n-values may be mixed : -100#5000/random/100/the_end/locationNameHere\n").defineList("reflection_whitelisted_blocks", (List)Lists.newArrayList(), obj -> obj instanceof String);
        }
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue allowParticles;

        ClientConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Rendering");
            this.allowParticles = builder.comment("Some people find them annoying. Feel free to disable them here if needed").translation("config.particles.telepad.allow").define("Allow Particle Spawning", true);
            builder.pop();
        }
    }
}

