/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network.server;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.IPacketBase;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.utility.TelepadEntry;

public class SPacketAddTelepadToWorld
implements IPacketBase {
    private TelepadEntry entry;

    public SPacketAddTelepadToWorld(TelepadEntry entry) {
        this.entry = entry;
    }

    public SPacketAddTelepadToWorld(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public SPacketAddTelepadToWorld() {
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        this.entry.writeToBuffer(buf);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.entry = new TelepadEntry(buf);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                WorldDataHandler wdh = WorldDataHandler.get((LevelAccessor)player.f_19853_);
                TelepadEntry old_entry = wdh.getEntryForLocation(this.entry.position, this.entry.dimensionID);
                if (old_entry == null) {
                    wdh.addEntry(this.entry);
                } else if (old_entry.isMissingFromLocation) {
                    wdh.updateEntry(old_entry, this.entry);
                }
                wdh.m_77760_(true);
            }
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void register(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketAddTelepadToWorld.class, SPacketAddTelepadToWorld::encode, SPacketAddTelepadToWorld::new, SPacketAddTelepadToWorld::handle);
    }
}

