/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.network.server;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.handler.ConfigData;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.network.IPacketBase;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.utility.TelepadEntry;
import subaraki.telepads.utility.masa.Teleport;

public class SPacketTeleport
implements IPacketBase {
    public TelepadEntry goTo;
    public BlockPos oldPos;
    public boolean force;

    public SPacketTeleport(BlockPos playerFrom, TelepadEntry goTo, boolean forceTeleport) {
        this.oldPos = playerFrom;
        this.goTo = goTo;
        this.force = forceTeleport;
    }

    public SPacketTeleport(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    public SPacketTeleport() {
    }

    private static boolean teleportPenalty(Player player) {
        int expConsuming = ConfigData.expConsume;
        int lvlConsuming = ConfigData.lvlConsume;
        if (expConsuming == 0 && lvlConsuming == 0) {
            return true;
        }
        if (lvlConsuming > 0) {
            if (player.f_36078_ >= lvlConsuming) {
                player.m_6749_(-lvlConsuming);
                return true;
            }
            return false;
        }
        float actualExpInBar = player.f_36080_ * (float)player.m_36323_();
        if (actualExpInBar < (float)expConsuming) {
            if (player.f_36078_ == 0) {
                return false;
            }
            expConsuming = (int)((float)expConsuming - actualExpInBar);
            player.m_6749_(-1);
            actualExpInBar = player.m_36323_();
            float total = actualExpInBar - (float)expConsuming;
            player.f_36080_ = 0.0f;
            if (total < 0.0f) {
                total = 0.0f;
            }
            player.m_6756_((int)total);
            return true;
        }
        float total = actualExpInBar - (float)expConsuming;
        player.f_36080_ = 0.0f;
        player.m_6756_((int)total);
        return true;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.oldPos.m_121878_());
        this.goTo.writeToBuffer(buf);
        buf.writeBoolean(this.force);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.oldPos = BlockPos.m_122022_((long)buf.readLong());
        this.goTo = new TelepadEntry(buf);
        this.force = buf.readBoolean();
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            WorldDataHandler wdh = WorldDataHandler.get((LevelAccessor)player.f_19853_);
            TelepadData.get((Player)player).ifPresent(data -> {
                data.setInTeleportGui(false);
                BlockPos destination = this.goTo.position.m_7494_();
                ResourceKey<Level> destination_dimension_id = this.goTo.dimensionID;
                int penalty = ConfigData.expConsume;
                if (penalty > 0 && player.f_36078_ == 0 && player.f_36080_ * (float)player.m_36323_() <= (float)penalty) {
                    player.m_5661_((Component)new TranslatableComponent("no.exp").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED))), true);
                    return;
                }
                if (this.goTo.dimensionID.equals((Object)player.f_19853_.m_46472_())) {
                    if (this.force && SPacketTeleport.teleportPenalty((Player)player)) {
                        Teleport.teleportEntityInsideSameDimension((Entity)player, destination);
                        return;
                    }
                    if (wdh.contains(this.goTo)) {
                        if (!this.goTo.isPowered) {
                            if (destination_dimension_id.equals((Object)player.f_19853_.m_46472_()) && SPacketTeleport.teleportPenalty((Player)player)) {
                                Teleport.teleportEntityInsideSameDimension((Entity)player, destination);
                            }
                        } else {
                            player.m_5661_((Component)new TranslatableComponent("no.power").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED))), true);
                        }
                    } else {
                        data.setInTeleportGui(true);
                    }
                } else {
                    if (this.force && SPacketTeleport.teleportPenalty((Player)player)) {
                        Teleport.teleportEntityToDimension(player, destination, destination_dimension_id);
                        return;
                    }
                    if (wdh.contains(this.goTo)) {
                        if (!this.goTo.isPowered) {
                            if (SPacketTeleport.teleportPenalty((Player)player)) {
                                Teleport.teleportEntityToDimension(player, destination, destination_dimension_id);
                            }
                        } else {
                            player.m_5661_((Component)new TranslatableComponent("no.power").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED))), true);
                        }
                    }
                }
            });
        });
        context.get().setPacketHandled(true);
    }

    @Override
    public void register(int id) {
        NetworkHandler.NETWORK.registerMessage(id, SPacketTeleport.class, SPacketTeleport::encode, SPacketTeleport::new, SPacketTeleport::handle);
    }
}

