/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.registry;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import subaraki.telepads.item.ItemEnderBead;
import subaraki.telepads.item.ItemEnderNecklace;
import subaraki.telepads.registry.TelepadBlocks;

public class TelepadItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"telepads");
    public static final RegistryObject<Item> TELEPAD = ITEMS.register("telepad", () -> new BlockItem((Block)TelepadBlocks.TELEPAD.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40752_)){

        public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            super.m_7373_(stack, worldIn, tooltip, flagIn);
            if (stack.m_41782_()) {
                String[] tags = new String[]{"colorFrame", "colorBase"};
                String[] translate_missing_dye = new String[]{"feet.color", "arrow.color"};
                String[] translate_part_names = new String[]{"feet.name", "arrow.name"};
                int iteration = 0;
                for (String tag : tags) {
                    if (stack.m_41782_() && stack.m_41783_() != null && stack.m_41783_().m_128441_(tag)) {
                        int saved_color = stack.m_41783_().m_128451_(tag);
                        Object color_name = translate_missing_dye[iteration];
                        for (DyeColor dye : DyeColor.values()) {
                            if (dye.m_41068_()[0] != (float)((saved_color & 0xFF0000) >> 16) / 255.0f || dye.m_41068_()[1] != (float)((saved_color & 0xFF00) >> 8) / 255.0f || dye.m_41068_()[2] != (float)(saved_color & 0xFF) / 255.0f) continue;
                            color_name = "item.minecraft.firework_star." + dye.m_41065_();
                            break;
                        }
                        TranslatableComponent part_name = new TranslatableComponent(translate_part_names[iteration]);
                        TranslatableComponent dye_name = new TranslatableComponent((String)color_name);
                        TextComponent text = new TextComponent(part_name.getString() + dye_name.getString());
                        tooltip.add((Component)text);
                    }
                    ++iteration;
                }
            }
        }
    });
    public static final RegistryObject<Item> BEAD = ITEMS.register("ender_bead", ItemEnderBead::new);
    public static final RegistryObject<Item> NECKLACE = ITEMS.register("ender_bead_necklace", ItemEnderNecklace::new);
    public static final RegistryObject<Item> TOGGLER = ITEMS.register("toggler", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
    public static final RegistryObject<Item> TRANSMITTER = ITEMS.register("transmitter", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40751_)));
    public static final RegistryObject<Item> CYCLE_ROD = ITEMS.register("creative_rod", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40751_)){

        public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent("can be used by people with creative access to enable telepads to teleport to a location defined in config"));
        }
    });
    public static final RegistryObject<Item> PUBLIC_TOGGLE_ROD = ITEMS.register("creative_rod_public", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40751_)){

        public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
            tooltip.add((Component)new TextComponent("can be used by people with creative access to toggle public acces to a telepad"));
        }
    });
}

