/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.registry.forge_bus;

import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.client.CPacketEditWhiteListEntry;
import subaraki.telepads.tileentity.TileEntityTelepad;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="telepads")
public class PlayerTracker {
    @SubscribeEvent
    public static void updateEntity(LivingEvent.LivingUpdateEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            TelepadData.get(player).ifPresent(data -> {
                BlockEntity patt1210$temp = event.getEntityLiving().f_19853_.m_7702_(event.getEntityLiving().m_142538_());
                if (patt1210$temp instanceof TileEntityTelepad) {
                    TileEntityTelepad te = (TileEntityTelepad)patt1210$temp;
                } else {
                    if (data.getCounter() != TelepadData.getMaxTime()) {
                        data.setCounter(TelepadData.getMaxTime());
                    }
                    if (data.isInTeleportGui()) {
                        data.setInTeleportGui(false);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void login(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerTracker.syncFriendList((PlayerEvent)event);
    }

    @SubscribeEvent
    public static void dimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        PlayerTracker.syncFriendList((PlayerEvent)event);
    }

    private static void syncFriendList(PlayerEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            TelepadData.get((Player)player2).ifPresent(data -> data.getWhitelist().forEach((name, uuid) -> NetworkHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new CPacketEditWhiteListEntry((String)name, (UUID)uuid, true))));
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        TelepadData.get(event.getOriginal()).ifPresent(data -> TelepadData.get(event.getPlayer()).ifPresent(newdata -> newdata.overrideEntries(data.getEntries())));
    }
}

