/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import subaraki.telepads.capability.player.TelepadData;
import subaraki.telepads.network.NetworkHandler;
import subaraki.telepads.network.server.SPacketAddTelepadToWorld;
import subaraki.telepads.utility.ClientReferences;
import subaraki.telepads.utility.TelepadEntry;

public class NameTelepadScreen
extends Screen {
    private final int textFieldWidth = 150;
    private final int textFieldHeight = 20;
    private final String textShare = new TranslatableComponent("button.share").getString();
    private final String textConfirmShare = new TranslatableComponent("confirm.share").getString();
    private final String textNegateShare = new TranslatableComponent("negate.share").getString();
    private final String textEnter = new TranslatableComponent("enter.to.confirm").getString();
    private final BlockPos position;
    protected String sharing = "";
    private EditBox textfieldBox;
    private int centerX;
    private int centerY;
    private String textNameYourPad;
    private boolean share = false;
    private boolean showSharing;

    public NameTelepadScreen(BlockPos position) {
        super((Component)new TranslatableComponent("name.pick.screen"));
        this.position = position;
    }

    public boolean m_7043_() {
        return false;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.centerX = this.f_96543_ / 2;
        this.centerY = this.f_96544_ / 2;
        this.initTextField();
        MutableComponent translation = new TranslatableComponent("name.your.telepad").m_7220_((Component)new TextComponent(" : "));
        this.textNameYourPad = translation.getString();
        this.initButtons();
    }

    private void initButtons() {
        TelepadData.get((Player)this.f_96541_.f_91074_).ifPresent(data -> {
            if (!data.getWhitelist().isEmpty()) {
                this.showSharing = true;
                this.m_142416_((GuiEventListener)new Button(this.centerX - 40, this.centerY + 20, 45, 20, (Component)new TranslatableComponent(this.textShare), b -> {
                    this.share = !this.share;
                }));
            }
        });
    }

    private void initTextField() {
        this.textfieldBox = new EditBox(this.f_96547_, this.centerX - 75, this.centerY - 50, 150, 20, (Component)new TextComponent("field_name"));
        this.textfieldBox.m_94182_(true);
        this.textfieldBox.m_94186_(true);
        this.textfieldBox.m_94190_(false);
        this.textfieldBox.m_94178_(true);
        ResourceLocation resLoc = this.f_96541_.f_91073_.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)this.f_96541_.f_91073_.m_204166_(this.f_96541_.f_91074_.m_142538_()).m_203334_()));
        String biome_name = "biome." + resLoc.m_135827_() + "." + resLoc.m_135815_();
        TranslatableComponent biome = new TranslatableComponent(biome_name);
        String format_name = biome.getString().substring(0, Math.min(15, biome.getString().length()));
        this.textfieldBox.m_94144_(format_name);
        this.textfieldBox.m_94199_(16);
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.textfieldBox.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.showSharing) {
            this.sharing = this.share ? this.textConfirmShare : this.textNegateShare;
        }
        this.f_96547_.m_92750_(matrixStack, this.sharing, (float)(this.centerX - this.f_96547_.m_92895_(this.sharing) / 2 + 30), (float)(this.centerY + 27), 0xAFAFAF);
        this.f_96547_.m_92750_(matrixStack, this.textEnter, (float)(this.centerX - this.f_96547_.m_92895_(this.textEnter) / 2), (float)this.centerY, 0xFFFFFF);
        this.f_96547_.m_92750_(matrixStack, this.textNameYourPad + this.textfieldBox.m_94155_(), (float)(this.centerX - this.f_96547_.m_92895_(this.textNameYourPad + this.textfieldBox.m_94155_()) / 2), (float)(this.centerY - 20), 0xFF0000);
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        this.textfieldBox.m_7933_(keyCode, scanCode, p_keyPressed_3_);
        if (keyCode == 257 || keyCode == 335 || keyCode == 256) {
            TelepadData.get(ClientReferences.getClientPlayer()).ifPresent(data -> {
                TelepadEntry telepad_entry = new TelepadEntry(this.textfieldBox.m_94155_(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), this.position);
                telepad_entry.addUser(ClientReferences.getClientPlayer().m_142081_());
                if (this.share) {
                    data.getWhitelist().values().forEach(telepad_entry::addUser);
                }
                NetworkHandler.NETWORK.sendToServer((Object)new SPacketAddTelepadToWorld(telepad_entry));
            });
            this.m_7379_();
            this.m_7861_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    public boolean m_5534_(char car, int index) {
        this.textfieldBox.m_5534_(car, index);
        return super.m_5534_(car, index);
    }
}

