/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.utility;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class TelepadEntry {
    private final ArrayList<UUID> users = Lists.newArrayList();
    public String entryName;
    public ResourceKey<Level> dimensionID;
    public BlockPos position;
    public boolean isPowered;
    public boolean hasTransmitter;
    public boolean isPublic;
    public boolean isMissingFromLocation = false;

    public TelepadEntry(FriendlyByteBuf buf) {
        this(buf.m_130136_(256), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130277_())), new BlockPos(buf.readInt(), buf.readInt(), buf.readInt()));
        this.addDetails(buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
        int size = buf.readInt();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.addUser(buf.m_130259_());
            }
        }
    }

    public TelepadEntry(CompoundTag tag) {
        this(tag.m_128461_("entryName"), (ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dimensionID"))), new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z")));
        this.addDetails(tag.m_128471_("power"), tag.m_128471_("transmitter"), tag.m_128471_("public"), tag.m_128471_("missing"));
        int size = tag.m_128451_("size");
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                this.users.add(UUID.fromString(tag.m_128461_("id_" + i)));
            }
        }
    }

    public TelepadEntry(String name, ResourceKey<Level> dimension, BlockPos pos) {
        this.entryName = name;
        this.dimensionID = dimension;
        this.position = pos;
    }

    private TelepadEntry addDetails(boolean isPowered, boolean hasTransmitter, boolean isPublic, boolean isMissing) {
        this.isPowered = isPowered;
        this.hasTransmitter = hasTransmitter;
        this.isPublic = isPublic;
        this.isMissingFromLocation = isMissing;
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128359_("entryName", this.entryName);
        tag.m_128359_("dimensionID", this.dimensionID.m_135782_().toString());
        tag.m_128379_("power", this.isPowered);
        tag.m_128379_("transmitter", this.hasTransmitter);
        tag.m_128379_("public", this.isPublic);
        tag.m_128405_("x", this.position.m_123341_());
        tag.m_128405_("y", this.position.m_123342_());
        tag.m_128405_("z", this.position.m_123343_());
        tag.m_128379_("missing", this.isMissingFromLocation);
        tag.m_128405_("size", this.users.size());
        if (this.users.size() > 0) {
            for (int i = 0; i < this.users.size(); ++i) {
                tag.m_128359_("id_" + i, this.users.get(i).toString());
            }
        }
        return tag;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130070_(this.entryName);
        buf.m_130070_(this.dimensionID.m_135782_().toString());
        buf.writeInt(this.position.m_123341_());
        buf.writeInt(this.position.m_123342_());
        buf.writeInt(this.position.m_123343_());
        buf.writeBoolean(this.isPowered);
        buf.writeBoolean(this.hasTransmitter);
        buf.writeBoolean(this.isPublic);
        buf.writeBoolean(this.isMissingFromLocation);
        buf.writeInt(this.users.size());
        if (!this.users.isEmpty()) {
            this.users.forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130077_(arg_0));
        }
    }

    public String toString() {
        return "Entry Name: " + this.entryName + " DimensionID: " + this.dimensionID + " " + this.position.toString() + " Public Pad:" + this.isPublic + " transmitter: " + this.hasTransmitter + " is powered: " + this.isPowered + " is missing: " + this.isMissingFromLocation + " Users : " + this.users;
    }

    public boolean equals(Object compared) {
        if (compared instanceof TelepadEntry) {
            TelepadEntry entry = (TelepadEntry)compared;
            return this.entryName.equals(entry.entryName) && this.dimensionID == entry.dimensionID && this.position.equals((Object)entry.position);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.entryName, this.dimensionID, this.position);
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public void setTransmitter(boolean flag) {
        this.hasTransmitter = flag;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public boolean canUse(UUID player_id) {
        return this.isPublic || this.users.contains(player_id);
    }

    public void addUser(UUID player_id) {
        this.users.add(player_id);
    }

    public void removeUser(UUID player_id) {
        this.users.remove(player_id);
    }
}

