/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import subaraki.telepads.block.BlockTelepad;
import subaraki.telepads.handler.WorldDataHandler;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.utility.TelepadEntry;

public class TelepadBlockInteraction {
    public static boolean interact(Action action, Level level, BlockPos pos, TileEntityTelepad telepad, BlockState state, BlockTelepad block) {
        return TelepadBlockInteraction.interact(action, level, pos, telepad, state, block, null);
    }

    public static boolean interact(Action action, Level level, BlockPos pos, TileEntityTelepad telepad, BlockState state, BlockTelepad block, DyeColor color) {
        TelepadEntry worldSaveEntryAtLocation = TelepadBlockInteraction.getEntry(pos, level);
        if (worldSaveEntryAtLocation != null) {
            boolean success = false;
            switch (action) {
                case TOGGLER_UPGRADE: {
                    if (telepad.hasRedstoneUpgrade()) break;
                    telepad.addRedstoneUpgrade();
                    block.m_6861_(state, level, pos, (Block)block, pos, false);
                    success = true;
                    break;
                }
                case TOGGLE_ACCESS: {
                    telepad.toggleAcces();
                    worldSaveEntryAtLocation.setPublic(telepad.isPublic());
                    success = true;
                    break;
                }
                case TRANSMITTER: {
                    if (worldSaveEntryAtLocation.hasTransmitter) break;
                    telepad.addDimensionUpgrade(true);
                    worldSaveEntryAtLocation.hasTransmitter = true;
                    success = true;
                    break;
                }
                case CYCLE: {
                    telepad.rotateCoordinateHandlerIndex();
                    success = true;
                    break;
                }
                case WASH: {
                    if (telepad.getColorFeet() != TileEntityTelepad.COLOR_FEET_BASE) {
                        TelepadBlockInteraction.wash(telepad.getColorFeet(), level, pos);
                        telepad.setFeetColor(TileEntityTelepad.COLOR_FEET_BASE);
                        success = true;
                    }
                    if (telepad.getColorArrow() == TileEntityTelepad.COLOR_ARROW_BASE) break;
                    TelepadBlockInteraction.wash(telepad.getColorArrow(), level, pos);
                    telepad.setArrowColor(TileEntityTelepad.COLOR_ARROW_BASE);
                    success = true;
                    break;
                }
                case DYE: {
                    if (color == null) break;
                    float red = color.m_41068_()[0];
                    float green = color.m_41068_()[1];
                    float blue = color.m_41068_()[2];
                    int rgb = (int)(red * 255.0f);
                    rgb = (rgb << 8) + (int)(green * 255.0f);
                    rgb = (rgb << 8) + (int)(blue * 255.0f);
                    if (telepad.getColorFeet() == TileEntityTelepad.COLOR_FEET_BASE) {
                        telepad.setFeetColor(rgb);
                        success = true;
                        break;
                    }
                    if (telepad.getColorArrow() != TileEntityTelepad.COLOR_ARROW_BASE) break;
                    telepad.setArrowColor(rgb);
                    success = true;
                }
            }
            telepad.m_6596_();
            level.m_7260_(pos, state, state, 3);
            WorldDataHandler.get((LevelAccessor)level).updateEntry(worldSaveEntryAtLocation);
            return success;
        }
        return false;
    }

    private static void wash(int color, Level world, BlockPos pos) {
        DyeColor edc = DyeColor.WHITE;
        for (DyeColor dye : DyeColor.values()) {
            if (dye.m_41068_()[0] != (float)((color & 0xFF0000) >> 16) / 255.0f || dye.m_41068_()[1] != (float)((color & 0xFF00) >> 8) / 255.0f || dye.m_41068_()[2] != (float)(color & 0xFF) / 255.0f) continue;
            edc = dye;
        }
        ItemStack stack = new ItemStack((ItemLike)DyeItem.m_41082_((DyeColor)edc), 1);
        if (!world.f_46443_) {
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
    }

    private static TelepadEntry getEntry(@Nonnull BlockPos pos, @Nonnull Level level) {
        return WorldDataHandler.get((LevelAccessor)level).getEntryForLocation(pos, (ResourceKey<Level>)level.m_46472_());
    }

    public static enum Action {
        TOGGLE_ACCESS,
        TRANSMITTER,
        TOGGLER_UPGRADE,
        CYCLE,
        DYE,
        WASH;

    }
}

