/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;

public class CoordinateHandler {
    public static final Random rand = new Random();
    public int worldsize = 25000000;
    int xi = 0;
    int zi = 0;
    String yi = "";
    ResourceLocation dim = null;
    String name = "default";

    public CoordinateHandler(ServerLevel server, String args) {
        String[] s = args.split("/");
        this.xi = this.define(s[0]);
        this.yi = s[1];
        this.zi = this.define(s[2]);
        this.defineDim(server, s[3]);
        this.name = s[4];
    }

    public String getTelepadName() {
        return this.name;
    }

    private int define(String definer) {
        if (definer.equalsIgnoreCase("random")) {
            return rand.nextInt(this.worldsize * 2) - this.worldsize;
        }
        if (definer.contains("#")) {
            String[] vals = definer.split("#");
            int min = Integer.parseInt(vals[0]);
            int max = Integer.parseInt(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            int total = 0;
            total = min < 0 && max >= 0 ? max + -1 * min : max + min;
            int result = rand.nextInt(total);
            if (min < 0 && max >= 0) {
                result += min;
            }
            return result;
        }
        return Integer.parseInt(definer);
    }

    private void defineDim(ServerLevel world, String dimension) {
        if (dimension.equalsIgnoreCase("random")) {
            ArrayList list = Lists.newArrayList();
            for (ServerLevel dim : world.m_7654_().m_129785_()) {
                list.add(dim.m_46472_().m_135782_());
            }
            this.dim = (ResourceLocation)list.get(rand.nextInt(list.size()));
        } else {
            this.dim = new ResourceLocation(dimension);
        }
    }

    private int defineY(String definer, Level world) {
        if (definer.equalsIgnoreCase("random")) {
            world.m_46865_(new BlockPos(this.xi, 0, this.zi));
            return Math.max(world.m_6924_(Heightmap.Types.WORLD_SURFACE, this.xi, this.zi), 0);
        }
        if (definer.contains("#")) {
            int counter;
            String[] vals = definer.split("#");
            int min = Integer.parseInt(vals[0]);
            int max = Integer.parseInt(vals[1]);
            if (max < min) {
                throw new IllegalArgumentException(min + "cannot be more then " + max + "! this is an error from the end user in the Telepads configuration file!");
            }
            BlockPos pos = new BlockPos(this.xi, min, this.zi);
            for (counter = min; counter < max; ++counter) {
                if (world.m_8055_(pos).m_60796_((BlockGetter)world, pos) && world.m_46859_(pos.m_7494_())) break;
                pos = new BlockPos(this.xi, counter, this.zi);
            }
            int result = counter;
            if (counter >= max) {
                result = min < 0 && max >= 0 ? max + -1 * min : max + min;
                result = result / 2 + min;
            }
            return result;
        }
        return Integer.parseInt(definer);
    }

    public BlockPos getPosition(Level world) {
        int y = this.defineY(this.yi, world);
        return new BlockPos(this.xi, y, this.zi);
    }

    public ResourceLocation getDimension() {
        return this.dim;
    }
}

