/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import subaraki.telepads.mod.Telepads;
import subaraki.telepads.utility.TelepadEntry;

public class WorldDataHandler
extends SavedData {
    private static final String TELEPADS_WORLD_SAVE_DATA = "telepads_world_save_data";
    private ArrayList<TelepadEntry> allTelepads = new ArrayList();

    public WorldDataHandler() {
    }

    public WorldDataHandler(CompoundTag nbt) {
        this.load(nbt);
    }

    public static WorldDataHandler get(LevelAccessor world) {
        ServerLevel overworld = ((ServerLevel)world).m_7654_().m_129880_(Level.f_46428_);
        if (overworld != null) {
            return (WorldDataHandler)overworld.m_8895_().m_164861_(WorldDataHandler::new, WorldDataHandler::new, TELEPADS_WORLD_SAVE_DATA);
        }
        Telepads.log.warn("**************");
        Telepads.log.warn("WorldSave Wasn't found ! This may be an error.");
        Telepads.log.warn("**************");
        return new WorldDataHandler();
    }

    public void load(CompoundTag nbt) {
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        ListTag taglist = nbt.m_128437_("entries", 10);
        for (int entryTag = 0; entryTag < taglist.size(); ++entryTag) {
            entryList.add(new TelepadEntry(taglist.m_128728_(entryTag)));
        }
        this.allTelepads = entryList;
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag taglist = new ListTag();
        if (!this.allTelepads.isEmpty()) {
            for (TelepadEntry entry : this.allTelepads) {
                taglist.add((Object)entry.writeToNBT(new CompoundTag()));
            }
        }
        nbt.m_128365_("entries", (Tag)taglist);
        return nbt;
    }

    public void addEntry(TelepadEntry entry) {
        if (!this.contains(entry)) {
            this.allTelepads.add(entry);
        }
    }

    public boolean contains(TelepadEntry entry) {
        if (this.allTelepads.isEmpty()) {
            return false;
        }
        for (TelepadEntry pad : this.allTelepads) {
            if (!entry.equals(pad)) continue;
            return true;
        }
        return false;
    }

    public void removeEntry(TelepadEntry entry) {
        if (this.contains(entry)) {
            this.allTelepads.remove(entry);
        }
    }

    public TelepadEntry getEntryForLocation(BlockPos pos, ResourceKey<Level> dimID) {
        if (this.allTelepads.isEmpty()) {
            return null;
        }
        for (TelepadEntry entry : this.allTelepads) {
            if (!entry.position.equals((Object)pos) || !entry.dimensionID.equals(dimID)) continue;
            return entry;
        }
        return null;
    }

    public void updateEntry(TelepadEntry entry) {
        if (this.contains(entry) && this.getEntryForLocation(entry.position, entry.dimensionID) != null) {
            this.allTelepads.remove(this.getEntryForLocation(entry.position, entry.dimensionID));
            this.allTelepads.add(entry);
        }
    }

    public void updateEntry(TelepadEntry old, TelepadEntry entry) {
        for (int i = 0; i < this.allTelepads.size(); ++i) {
            if (!old.equals(this.allTelepads.get(i))) continue;
            this.allTelepads.set(i, entry);
            break;
        }
    }

    public boolean isEntryPowered(TelepadEntry entry) {
        return this.contains(entry) && this.getEntryForLocation((BlockPos)entry.position, entry.dimensionID).isPowered;
    }

    public List<TelepadEntry> getEntries() {
        return this.allTelepads;
    }

    public void copyOverEntries(ArrayList<TelepadEntry> allTelepads) {
        this.allTelepads = allTelepads;
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="telepads")
    public static class WorldDataHandlerSaveEvent {
        @SubscribeEvent
        public static void onWorldSave(LevelEvent.Save event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)levelAccessor;
                ServerLevel overworld = server.m_7654_().m_129880_(Level.f_46428_);
                WorldDataHandler.get((LevelAccessor)overworld).m_77762_();
            }
        }

        @SubscribeEvent
        public static void onWorldLoad(LevelEvent.Load event) {
            LevelAccessor levelAccessor = event.getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)levelAccessor;
                ServerLevel overworld = server.m_7654_().m_129880_(Level.f_46428_);
                WorldDataHandler.get((LevelAccessor)overworld);
            }
        }
    }
}

