/*
 * Decompiled with CFR 0.152.
 */
package subaraki.telepads.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import subaraki.telepads.registry.mod_bus.RegisterClientSetup;
import subaraki.telepads.tileentity.TileEntityTelepad;
import subaraki.telepads.tileentity.render.ModelTelepad;

public class TileEntityTelepadRenderer
implements BlockEntityRenderer<TileEntityTelepad> {
    private static final String resourcePath = "telepads:textures/entity/tile/";
    private static final ResourceLocation base = new ResourceLocation("telepads:textures/entity/tile/telepad_base.png");
    private static final ResourceLocation pads = new ResourceLocation("telepads:textures/entity/tile/telepad_pads.png");
    private static final ResourceLocation frame = new ResourceLocation("telepads:textures/entity/tile/telepad_frame.png");
    private static final ResourceLocation transmitterFrameA = new ResourceLocation("telepads:textures/entity/tile/telepad_dimension_upgrade.png");
    private static final ResourceLocation transmitterFrameB = new ResourceLocation("telepads:textures/entity/tile/telepad_dimension_upgrade_2.png");
    private static final ResourceLocation transmitterFrameC = new ResourceLocation("telepads:textures/entity/tile/telepad_dimension_upgrade_3.png");
    private static final ResourceLocation transmitterFrameD = new ResourceLocation("telepads:textures/entity/tile/telepad_dimension_upgrade_4.png");
    private static ModelTelepad modeltelepad;
    private static int transmitterFrameCounter;

    public TileEntityTelepadRenderer(BlockEntityRendererProvider.Context c) {
        modeltelepad = new ModelTelepad(Minecraft.m_91087_().m_167973_().m_171103_(RegisterClientSetup.TELEPAD));
    }

    public void render(TileEntityTelepad te, float partialTicks, PoseStack stack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ++transmitterFrameCounter;
        if (!te.hasRedstoneUpgrade() || te.hasRedstoneUpgrade() && !te.isPowered()) {
            stack.m_85836_();
            this.renderCube(stack.m_85850_().m_85861_(), bufferIn.m_6299_(RenderType.m_173239_()));
            stack.m_85849_();
        }
        stack.m_85836_();
        stack.m_85837_(0.5, 2.25, 0.5);
        stack.m_85841_(1.0f, -1.0f, 1.0f);
        Color colorBase = new Color(te.getColorArrow());
        Color colorFrame = new Color(te.getColorFeet());
        this.renderPad(stack, colorFrame, colorBase, bufferIn, combinedLightIn, combinedOverlayIn);
        if (te.hasDimensionUpgrade()) {
            ResourceLocation resLocAnimation;
            stack.m_85836_();
            if (transmitterFrameCounter < 25) {
                resLocAnimation = transmitterFrameA;
            } else if (transmitterFrameCounter < 50) {
                resLocAnimation = transmitterFrameB;
            } else if (transmitterFrameCounter < 75) {
                resLocAnimation = transmitterFrameC;
            } else if (transmitterFrameCounter < 99) {
                resLocAnimation = transmitterFrameD;
            } else {
                transmitterFrameCounter = 0;
                resLocAnimation = transmitterFrameD;
            }
            stack.m_85841_(0.75f, 0.75f, 0.75f);
            stack.m_85837_((double)-0.1f, (double)0.45f, (double)0.1f);
            switch (te.getUpgradeRotation()) {
                case 0: {
                    stack.m_85845_(new Quaternion(0.0f, 0.0f, 0.0f, true));
                    stack.m_85837_(0.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    stack.m_85845_(new Quaternion(0.0f, -90.0f, 0.0f, true));
                    stack.m_85837_((double)-0.1f, 0.0, 0.0);
                    break;
                }
                case 2: {
                    stack.m_85845_(new Quaternion(0.0f, 180.0f, 0.0f, true));
                    stack.m_85837_((double)-0.2f, 0.0, (double)0.2f);
                    break;
                }
                default: {
                    stack.m_85845_(new Quaternion(0.0f, 90.0f, 0.0f, true));
                    stack.m_85837_(0.0, 0.0, (double)0.2f);
                }
            }
            modeltelepad.renderUpgrade(stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)resLocAnimation)), combinedLightIn, combinedOverlayIn);
            stack.m_85849_();
        }
        stack.m_85849_();
        if (te.hasRedstoneUpgrade()) {
            this.renderTorch(te, stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_)), combinedLightIn, combinedOverlayIn, -0.4375, -0.25, 0.4375);
            this.renderTorch(te, stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_)), combinedLightIn, combinedOverlayIn, -0.4375, -0.25, -0.4375);
            this.renderTorch(te, stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_)), combinedLightIn, combinedOverlayIn, 0.4375, -0.25, 0.4375);
            this.renderTorch(te, stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)InventoryMenu.f_39692_)), combinedLightIn, combinedOverlayIn, 0.4375, -0.25, -0.4375);
        }
    }

    private void renderTorch(TileEntityTelepad te, PoseStack stack, VertexConsumer builder, int combinedLight, int combinedOverlay, double offsetX, double offsetY, double offsetZ) {
        stack.m_85836_();
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.m_91087_().m_91289_();
        BlockState state = (BlockState)Blocks.f_50174_.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(te.isPowered()));
        stack.m_85837_(offsetX, offsetY, offsetZ);
        BakedModel model = blockrendererdispatcher.m_110910_(state);
        blockrendererdispatcher.m_110937_().renderModel(stack.m_85850_(), builder, te.m_58900_(), model, 0.0f, 0.0f, 0.0f, combinedLight, combinedOverlay, ModelData.EMPTY, RenderType.m_110451_());
        stack.m_85849_();
    }

    public void renderPad(PoseStack stack, Color colorFrame, Color colorBase, MultiBufferSource bufferIn, int packedLightIn, int packedOverlayIn) {
        float f2 = 1.5f;
        stack.m_85841_(f2, f2, f2);
        stack.m_85836_();
        modeltelepad.renderArrows(stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)base)), packedLightIn, packedOverlayIn, (float)colorBase.getRed() / 255.0f, (float)colorBase.getGreen() / 255.0f, (float)colorBase.getBlue() / 255.0f);
        stack.m_85849_();
        stack.m_85836_();
        modeltelepad.renderLegs(stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)pads)), packedLightIn, packedOverlayIn, (float)colorFrame.getRed() / 255.0f, (float)colorFrame.getGreen() / 255.0f, (float)colorFrame.getBlue() / 255.0f);
        stack.m_85849_();
        stack.m_85836_();
        modeltelepad.renderFrame(stack, bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)frame)), packedLightIn, packedOverlayIn, 1.0f, 1.0f, 1.0f);
        stack.m_85849_();
    }

    private void renderCube(Matrix4f stack, VertexConsumer vertexConsumer) {
        this.renderFace(stack, vertexConsumer, 0.03f, 0.97f, 0.19f, 0.19f, 0.97f, 0.97f, 0.03f, 0.03f);
    }

    private void renderFace(Matrix4f matrix4f, VertexConsumer vertexConsumer, float x0, float x1, float y0, float y1, float normalA, float normalB, float normalC, float normalD) {
        vertexConsumer.m_85982_(matrix4f, x0, y0, normalA).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y0, normalB).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x1, y1, normalC).m_5752_();
        vertexConsumer.m_85982_(matrix4f, x0, y1, normalD).m_5752_();
    }
}

