/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.blocks;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Random;
import net.darkhax.bookshelf.util.Position;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.subaraki.telepads.Telepads;
import net.subaraki.telepads.common.network.PacketSyncPoweredBlock;
import net.subaraki.telepads.handler.PlayerLocations;
import net.subaraki.telepads.tileentity.TileEntityTelepad;

public class BlockTelepad
extends BlockContainer {
    public BlockTelepad() {
        super(Material.field_151592_s);
        this.func_149663_c("telepad");
        this.func_149715_a(0.2f);
        this.func_149711_c(5.0f);
        this.func_149658_d("glass");
        this.func_149672_a(field_149778_k);
        this.func_149647_a(CreativeTabs.field_78029_e);
        this.setHarvestLevel("pickaxe", 1, 0);
        float offset = 0.5f;
        this.func_149676_a(0.5f - offset, 0.0f, 0.5f - offset, 0.5f + offset, 0.25f, 0.5f + offset);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityTelepad();
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block b, int par6) {
        super.func_149749_a(par1World, par2, par3, par4, b, par6);
        par1World.func_147475_p(par2, par3, par4);
    }

    public boolean canEntityDestroy(IBlockAccess world, int x, int y, int z, Entity entity) {
        return entity instanceof EntityPlayer;
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack is) {
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149689_a(World par1World, int x, int y, int z, EntityLivingBase elb, ItemStack is) {
        TileEntityTelepad te = new TileEntityTelepad();
        if (elb instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)elb;
            te.setDimension(par1World.field_73011_w.field_76574_g);
            p.openGui((Object)Telepads.instance, 1, par1World, x, y, z);
        }
        if (is.func_77942_o()) {
            if (is.func_77978_p().func_74764_b("colorFrame")) {
                te.setFrameColor(is.func_77978_p().func_74762_e("colorFrame"));
            }
            if (is.func_77978_p().func_74764_b("colorBase")) {
                te.setBaseColor(is.func_77978_p().func_74762_e("colorBase"));
            }
        }
        par1World.func_147471_g(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        par1World.func_147455_a(x, y, z, (TileEntity)te);
    }

    public boolean func_149727_a(World w, int x, int y, int z, EntityPlayer player, int meta, float f, float f1, float f2) {
        if (player.func_70694_bm() == null && player.func_70093_af() && w.func_147438_o(x, y, z) instanceof TileEntityTelepad) {
            TileEntityTelepad telepad = (TileEntityTelepad)w.func_147438_o(x, y, z);
            PlayerLocations pl = PlayerLocations.getProperties(player);
            boolean match = false;
            for (PlayerLocations.TelepadEntry tpe : pl.getEntries()) {
                if (tpe.position.getX() != x || tpe.position.getY() != y || tpe.position.getZ() != z) continue;
                match = true;
            }
            if (!match) {
                pl.addEntry(new PlayerLocations.TelepadEntry(telepad.getTelePadName(), telepad.getDimension(), new Position(x, y, z), false, false));
                if (!w.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Succesfully added " + telepad.getTelePadName()));
                }
            } else if (!w.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(telepad.getTelePadName() + " has already been registered"));
            }
            pl.sync();
        }
        return false;
    }

    public float func_149638_a(Entity ent) {
        return Float.MAX_VALUE;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (this.getTileEntityTelepad(world, x, y, z)) {
            TileEntityTelepad telepad = (TileEntityTelepad)world.func_147438_o(x, y, z);
            PlayerLocations pl = PlayerLocations.getProperties(player);
            for (PlayerLocations.TelepadEntry tpe : pl.getEntries()) {
                if (!tpe.position.equals((Object)new Position(telepad.field_145851_c, telepad.field_145848_d, telepad.field_145849_e)) || tpe.dimensionID != telepad.func_145831_w().field_73011_w.field_76574_g || !tpe.entryName.equals(telepad.getTelePadName())) continue;
                pl.removeEntry(tpe);
                this.dropPad(world, telepad, x, y, z);
                Telepads.printDebugMessage("pad was removed succesfully");
                if (telepad.hasDimensionUpgrade()) {
                    world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, new ItemStack(Telepads.transmitter, 1)));
                }
                return world.func_147468_f(x, y, z);
            }
        }
        return false;
    }

    private void dropPad(World world, TileEntityTelepad telepad, int x, int y, int z) {
        EntityItem ei = new EntityItem(world);
        ei.func_70107_b((double)x, (double)y, (double)z);
        ItemStack stack = new ItemStack(Telepads.blockPad);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("colorBase", telepad.getColorBase());
        nbt.func_74768_a("colorFrame", telepad.getColorFrame());
        stack.func_77982_d(nbt);
        ei.func_92058_a(stack);
        world.func_72838_d((Entity)ei);
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        TileEntityTelepad telepad;
        if (this.getTileEntityTelepad(world, x, y, z) && (telepad = (TileEntityTelepad)world.func_147438_o(x, y, z)).hasRedstoneUpgrade() && !world.field_72995_K) {
            boolean flag = false;
            if (world.func_94577_B(x, y, z) > 0) {
                flag = true;
            }
            for (int x2 = x - 1; x2 < x + 2; ++x2) {
                for (int z2 = z - 1; z2 < z + 2; ++z2) {
                    if (!world.func_147439_a(x2, y, z2).func_149744_f()) continue;
                    int meta = world.func_72805_g(x2, y, z2);
                    if (world.func_147439_a(x2, y, z2).func_149748_c((IBlockAccess)world, x2, y, z2, meta) <= 0 && world.func_147439_a(x2, y, z2).func_149709_b((IBlockAccess)world, x2, y, z2, meta) <= 0) continue;
                    flag = true;
                }
            }
            telepad.setPowered(flag);
            Telepads.instance.network.sendToAll((IMessage)new PacketSyncPoweredBlock(flag, new Position(x, y, z)));
            telepad.func_70296_d();
            if (!world.field_72995_K) {
                for (Integer i : DimensionManager.getStaticDimensionIDs()) {
                    WorldServer ws = MinecraftServer.func_71276_C().func_71218_a(i.intValue());
                    for (Object o : ws.field_73010_i) {
                        if (!(o instanceof EntityPlayer)) continue;
                        EntityPlayer player = (EntityPlayer)o;
                        PlayerLocations pl = PlayerLocations.getProperties(player);
                        for (PlayerLocations.TelepadEntry tpe : pl.getEntries()) {
                            if (!tpe.position.equals((Object)new Position(x, y, z)) || tpe.dimensionID != world.field_73011_w.field_76574_g) continue;
                            tpe.setPowered(flag);
                        }
                        pl.sync();
                    }
                }
            }
        }
    }

    private boolean getTileEntityTelepad(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        TileEntityTelepad telepad = null;
        if (te == null) {
            return false;
        }
        if (te instanceof TileEntityTelepad) {
            telepad = (TileEntityTelepad)te;
        }
        return telepad != null;
    }
}

