/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.client.renderer;

import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.subaraki.telepads.client.model.ModelTelepad;
import net.subaraki.telepads.tileentity.TileEntityTelepad;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityTelepad
extends TileEntitySpecialRenderer {
    private static String resourcePath = "telepads:textures/entity/tile/";
    private static ResourceLocation base = new ResourceLocation(resourcePath + "telepad_base.png");
    private static ResourceLocation pads = new ResourceLocation(resourcePath + "telepad_pads.png");
    private static ResourceLocation frame = new ResourceLocation(resourcePath + "telepad_frame.png");
    private static ResourceLocation frame_empty = new ResourceLocation(resourcePath + "telepad_frame_interDimension.png");
    private static ResourceLocation frame_upgrade = new ResourceLocation(resourcePath + "telepad_dimensionUpgrade.png");
    private static ResourceLocation frame_upgrade_2 = new ResourceLocation(resourcePath + "telepad_dimensionUpgrade_2.png");
    private static ResourceLocation frame_upgrade_3 = new ResourceLocation(resourcePath + "telepad_dimensionUpgrade_3.png");
    private static ResourceLocation frame_upgrade_4 = new ResourceLocation(resourcePath + "telepad_dimensionUpgrade_4.png");
    private static ResourceLocation frame_powered_off = new ResourceLocation("minecraft:textures/blocks/red_sand.png");
    private static ResourceLocation frame_powered_on = new ResourceLocation("minecraft:textures/blocks/redstone_block.png");
    private static int animation_counter;
    private static final ResourceLocation enderPortalEndSkyTextures;
    private static final ResourceLocation endPortalTextures;
    private static final Random teleporterRandom;
    FloatBuffer floatBuffer = GLAllocation.func_74529_h((int)16);
    ModelTelepad padModel = new ModelTelepad();
    RenderBlocks renderBlocks = new RenderBlocks();

    private FloatBuffer createBuffer(float par1, float par2, float par3, float par4) {
        this.floatBuffer.clear();
        this.floatBuffer.put(par1).put(par2).put(par3).put(par4);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void renderEndPortalSurface(double par2, double par4, double par6, float par8) {
        float f1 = (float)TileEntityRendererDispatcher.field_147554_b;
        float f2 = (float)TileEntityRendererDispatcher.field_147555_c;
        float f3 = (float)TileEntityRendererDispatcher.field_147552_d;
        GL11.glDisable((int)2896);
        teleporterRandom.setSeed(31100L);
        float f4 = 0.15f;
        par2 += 0.05;
        par6 += 0.05;
        par4 += 0.04;
        for (int i = 0; i < 16; ++i) {
            GL11.glPushMatrix();
            float f5 = 16 - i;
            float f6 = 0.3125f;
            float f7 = 1.0f / (f5 / 10.0f + 1.0f);
            if (i == 0) {
                this.func_147499_a(enderPortalEndSkyTextures);
                f7 = 0.1f;
                f5 = 65.0f;
                f6 = 0.125f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (i == 1) {
                this.func_147499_a(endPortalTextures);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
                f6 = 0.5f;
            }
            float f8 = (float)(-(par4 + (double)f4));
            float f9 = f8 + ActiveRenderInfo.field_74590_b;
            float f10 = f8 + f5 + ActiveRenderInfo.field_74590_b;
            float f11 = f9 / f10;
            GL11.glTranslatef((float)f1, (float)(f11 += (float)(par4 + (double)f4)), (float)f3);
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGeni((int)8194, (int)9472, (int)9217);
            GL11.glTexGeni((int)8195, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.createBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.createBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this.createBuffer(0.0f, 0.0f, 0.0f, 1.0f));
            GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this.createBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glEnable((int)3171);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glRotatef((float)((float)(Minecraft.func_71386_F() % 7000L) / 7000.0f), (float)1.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)f6, (float)f6, (float)f6);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glRotatef((float)((float)(i * i * 4321 + i * 9) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)0.0f);
            GL11.glTranslatef((float)(-f1), (float)(-f3), (float)(-f2));
            f9 = f8 + ActiveRenderInfo.field_74590_b;
            GL11.glTranslatef((float)(ActiveRenderInfo.field_74592_a * f5 / f9), (float)(ActiveRenderInfo.field_74591_c * f5 / f9), (float)(-f2));
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            f11 = teleporterRandom.nextFloat() * 0.5f + 0.1f;
            float f12 = teleporterRandom.nextFloat() * 0.5f + 0.4f;
            float f13 = teleporterRandom.nextFloat() * 0.5f + 0.5f;
            if (i == 0) {
                f13 = 1.0f;
                f12 = 1.0f;
                f11 = 1.0f;
            }
            double scale = 0.9;
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
            tessellator.func_78369_a(f11 * f7, f12 * f7, f13 * f7, 1.0f);
            tessellator.func_78377_a(par2, par4 + (double)f4, par6);
            tessellator.func_78377_a(par2, par4 + (double)f4, par6 + scale);
            tessellator.func_78377_a(par2 + scale, par4 + (double)f4, par6 + scale);
            tessellator.func_78377_a(par2 + scale, par4 + (double)f4, par6);
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glDisable((int)3171);
        GL11.glEnable((int)2896);
    }

    public void func_147500_a(TileEntity tileentity, double x, double y, double z, float f) {
        ++animation_counter;
        TileEntityTelepad te = null;
        if (tileentity instanceof TileEntityTelepad) {
            te = (TileEntityTelepad)tileentity;
        }
        if (te == null) {
            return;
        }
        if (!te.hasRedstoneUpgrade() || te.hasRedstoneUpgrade() && !te.isPowered()) {
            GL11.glPushMatrix();
            this.renderEndPortalSurface(x, y, z, f);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 2.25f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        Color colorBase = new Color(te.getColorBase());
        Color colorFrame = new Color(te.getColorFrame());
        this.renderPad(te, colorFrame, colorBase, x, y, z, f);
        if (te.hasDimensionUpgrade()) {
            GL11.glPushMatrix();
            if (animation_counter < 100) {
                this.func_147499_a(frame_upgrade);
            } else if (animation_counter < 200) {
                this.func_147499_a(frame_upgrade_2);
            } else if (animation_counter < 300) {
                this.func_147499_a(frame_upgrade_3);
            } else if (animation_counter < 400) {
                this.func_147499_a(frame_upgrade_4);
            } else {
                this.func_147499_a(frame_upgrade_4);
            }
            if (animation_counter == 900) {
                animation_counter = 0;
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
            GL11.glTranslatef((float)-0.1f, (float)0.45f, (float)0.1f);
            switch (te.getUpgradeRotation()) {
                case 0: {
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 1: {
                    GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.1f, (float)0.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-0.2f, (float)0.0f, (float)0.2f);
                    break;
                }
                case 3: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.2f);
                    break;
                }
                default: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.2f);
                }
            }
            this.padModel.renderUpgrade(0.0625f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (te.hasRedstoneUpgrade()) {
            this.renderTorch(te, -0.5, 0.4, -0.5, x, y, z);
            this.renderTorch(te, 0.5, 0.4, -0.5, x, y, z);
            this.renderTorch(te, -0.5, 0.4, 0.5, x, y, z);
            this.renderTorch(te, 0.5, 0.4, 0.5, x, y, z);
        }
    }

    private void renderTorch(TileEntityTelepad te, double offsetX, double offsetY, double offsetZ, double x, double y, double z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78373_b(x - (double)te.field_145851_c - offsetX, y - (double)te.field_145848_d - offsetY, z - (double)te.field_145849_e - offsetZ);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderBlocks.field_147845_a = te.func_145831_w();
        this.func_147499_a(TextureMap.field_110575_b);
        if (te.isPowered()) {
            this.renderBlocks.func_147805_b(Blocks.field_150429_aA, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        } else {
            this.renderBlocks.func_147805_b(Blocks.field_150437_az, te.field_145851_c, te.field_145848_d, te.field_145849_e);
        }
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public void renderPad(TileEntity tileentity, Color colorFrame, Color colorBase, double x, double y, double z, float f) {
        TileEntityTelepad te = null;
        if (tileentity instanceof TileEntityTelepad) {
            te = (TileEntityTelepad)tileentity;
        }
        float f2 = 1.5f;
        GL11.glScalef((float)f2, (float)f2, (float)f2);
        GL11.glPushMatrix();
        this.func_147499_a(base);
        GL11.glColor3f((float)((float)colorBase.getRed() / 255.0f), (float)((float)colorBase.getGreen() / 255.0f), (float)((float)colorBase.getBlue() / 255.0f));
        this.padModel.renderArrows(0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.func_147499_a(pads);
        GL11.glColor3f((float)((float)colorFrame.getRed() / 255.0f), (float)((float)colorFrame.getGreen() / 255.0f), (float)((float)colorFrame.getBlue() / 255.0f));
        this.padModel.renderLegs(0.0625f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        this.func_147499_a(frame);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.padModel.renderFrame(0.0625f);
        GL11.glPopMatrix();
    }

    static {
        enderPortalEndSkyTextures = new ResourceLocation("textures/environment/end_sky.png");
        endPortalTextures = new ResourceLocation("textures/entity/end_portal.png");
        teleporterRandom = new Random(31100L);
    }
}

