/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.bookshelf.util.Utilities;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.subaraki.telepads.Telepads;
import net.subaraki.telepads.handler.PlayerLocations;
import net.subaraki.telepads.tileentity.TileEntityTelepad;

public class PacketAddTelepadEntry
implements IMessage {
    private UUID playerUUID;
    private PlayerLocations.TelepadEntry entry;

    public PacketAddTelepadEntry(UUID playerUUID, PlayerLocations.TelepadEntry entry) {
        this.playerUUID = playerUUID;
        this.entry = entry;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entry = new PlayerLocations.TelepadEntry(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        this.entry.writeToByteBuf(buf);
    }

    public PacketAddTelepadEntry() {
    }

    public static class PacketAddTelepadEntryHandler
    implements IMessageHandler<PacketAddTelepadEntry, IMessage> {
        public IMessage onMessage(PacketAddTelepadEntry packet, MessageContext ctx) {
            PlayerLocations locations = PlayerLocations.getProperties(Utilities.getPlayerFromUUID((World)ctx.getServerHandler().field_147369_b.field_70170_p, (UUID)packet.playerUUID));
            Telepads.printDebugMessage(((PacketAddTelepadEntry)packet).entry.entryName);
            if (locations.getEntries().isEmpty()) {
                locations.addEntry(packet.entry);
            } else {
                for (PlayerLocations.TelepadEntry tpe : locations.getEntries()) {
                    if (tpe.position.equals((Object)((PacketAddTelepadEntry)packet).entry.position)) continue;
                    locations.addEntry(packet.entry);
                    locations.sync();
                    break;
                }
            }
            TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_147438_o(((PacketAddTelepadEntry)packet).entry.position.getX(), ((PacketAddTelepadEntry)packet).entry.position.getY(), ((PacketAddTelepadEntry)packet).entry.position.getZ());
            if (te instanceof TileEntityTelepad) {
                TileEntityTelepad telepad = (TileEntityTelepad)te;
                telepad.setTelePadName(((PacketAddTelepadEntry)packet).entry.entryName);
            }
            return null;
        }
    }
}

