/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.darkhax.bookshelf.util.Utilities;
import net.minecraft.world.World;
import net.subaraki.telepads.handler.PlayerLocations;

public class PacketRemoveTelepadEntry
implements IMessage {
    private UUID playerUUID;
    private PlayerLocations.TelepadEntry entry;

    public PacketRemoveTelepadEntry(UUID playerUUID, PlayerLocations.TelepadEntry entry) {
        this.playerUUID = playerUUID;
        this.entry = entry;
    }

    public void fromBytes(ByteBuf buf) {
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.entry = new PlayerLocations.TelepadEntry(buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        this.entry.writeToByteBuf(buf);
    }

    public PacketRemoveTelepadEntry() {
    }

    public static class PacketRemoveTelepadEntryHandler
    implements IMessageHandler<PacketRemoveTelepadEntry, IMessage> {
        public IMessage onMessage(PacketRemoveTelepadEntry packet, MessageContext ctx) {
            PlayerLocations locations = PlayerLocations.getProperties(Utilities.getPlayerFromUUID((World)ctx.getServerHandler().field_147369_b.field_70170_p, (UUID)packet.playerUUID));
            locations.removeEntry(packet.entry);
            locations.sync();
            return null;
        }
    }
}

