/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.common.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.darkhax.bookshelf.util.Utilities;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.subaraki.telepads.handler.PlayerLocations;

public class PacketSyncTelepadEntries
implements IMessage {
    private UUID playerUUID;
    private List<PlayerLocations.TelepadEntry> entries;

    public PacketSyncTelepadEntries(UUID playerUUID, List<PlayerLocations.TelepadEntry> entries) {
        this.playerUUID = playerUUID;
        this.entries = entries;
    }

    public void fromBytes(ByteBuf buf) {
        ArrayList<PlayerLocations.TelepadEntry> entryList = new ArrayList<PlayerLocations.TelepadEntry>();
        this.playerUUID = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        int size = buf.readInt();
        if (size <= 0) {
            return;
        }
        for (int index = 0; index < size; ++index) {
            entryList.add(new PlayerLocations.TelepadEntry(buf));
        }
        this.entries = entryList;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerUUID.toString());
        buf.writeInt(this.entries.size());
        for (PlayerLocations.TelepadEntry entry : this.entries) {
            entry.writeToByteBuf(buf);
        }
    }

    public PacketSyncTelepadEntries() {
    }

    public static class PacketSyncTelepadEntriesHandler
    implements IMessageHandler<PacketSyncTelepadEntries, IMessage> {
        public IMessage onMessage(PacketSyncTelepadEntries packet, MessageContext ctx) {
            EntityPlayer player = Utilities.getPlayerFromUUID((World)Utilities.thePlayer().field_70170_p, (UUID)packet.playerUUID);
            PlayerLocations.getProperties(player).overrideEntries(packet.entries);
            return null;
        }
    }
}

