/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.darkhax.bookshelf.util.Position;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.WorldServer;
import net.subaraki.telepads.Telepads;
import net.subaraki.telepads.tileentity.TileEntityTelepad;
import net.subaraki.telepads.util.TeleportUtility;

public class PacketTeleport
implements IMessage {
    public Position newPos;
    public Position oldPos;
    public int dimension;
    public boolean force;

    public PacketTeleport(Position newPos, int dimension, Position oldPos, boolean forceTeleport) {
        this.oldPos = oldPos;
        this.dimension = dimension;
        this.newPos = newPos;
        this.force = forceTeleport;
    }

    public void fromBytes(ByteBuf buf) {
        this.newPos = new Position(buf);
        this.oldPos = new Position(buf);
        this.dimension = buf.readInt();
        this.force = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        this.newPos.write(buf);
        this.oldPos.write(buf);
        buf.writeInt(this.dimension);
        buf.writeBoolean(this.force);
    }

    public PacketTeleport() {
    }

    private static void removePad(EntityPlayer player, Position removedDestinyPos, Position oldExisitingPostion, int dimension) {
        Telepads.proxy.openRemovalGui(player, removedDestinyPos, oldExisitingPostion, dimension);
    }

    public static class PacketTeleportHandler
    implements IMessageHandler<PacketTeleport, IMessage> {
        public IMessage onMessage(PacketTeleport packet, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            if (packet.dimension == player.field_71093_bK) {
                if (packet.force) {
                    packet.newPos.sendEntityToPosition((EntityLivingBase)player);
                    return null;
                }
                TileEntity te = player.field_70170_p.func_147438_o(packet.newPos.getX(), packet.newPos.getY(), packet.newPos.getZ());
                if (te != null && te instanceof TileEntityTelepad) {
                    TileEntityTelepad telepad = (TileEntityTelepad)player.field_70170_p.func_147438_o(packet.newPos.getX(), packet.newPos.getY(), packet.newPos.getZ());
                    if (!telepad.isPowered()) {
                        if (packet.dimension == player.field_70170_p.field_73011_w.field_76574_g) {
                            packet.newPos.sendEntityToPosition((EntityLivingBase)player);
                        }
                    } else {
                        player.func_145747_a((IChatComponent)new ChatComponentText("This pad was powered off"));
                    }
                } else {
                    PacketTeleport.removePad((EntityPlayer)player, packet.newPos, packet.oldPos, packet.dimension);
                }
            } else {
                WorldServer worldToCheck = MinecraftServer.func_71276_C().func_71218_a(packet.dimension);
                if (worldToCheck != null) {
                    TileEntity te = worldToCheck.func_147438_o(packet.newPos.getX(), packet.newPos.getY(), packet.newPos.getZ());
                    if (te != null && te instanceof TileEntityTelepad) {
                        TileEntityTelepad telepad = (TileEntityTelepad)worldToCheck.func_147438_o(packet.newPos.getX(), packet.newPos.getY(), packet.newPos.getZ());
                        if (packet.force) {
                            if (!telepad.isPowered()) {
                                TeleportUtility.transferPlayerToDimension(player, packet.dimension, packet.newPos);
                            }
                            return null;
                        }
                        if (!telepad.isPowered()) {
                            if (player instanceof EntityPlayerMP) {
                                TeleportUtility.transferPlayerToDimension(player, packet.dimension, packet.newPos);
                            }
                        } else {
                            player.func_145747_a((IChatComponent)new ChatComponentText("This pad was powered off"));
                        }
                    } else {
                        PacketTeleport.removePad((EntityPlayer)player, packet.newPos, packet.oldPos, packet.dimension);
                    }
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText("Could not teleport to other dimension " + packet.dimension));
                }
            }
            return null;
        }
    }
}

