/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration config;
    public static boolean allowDebugMessages;
    public static boolean allowParticleEffects;
    public static String particleName;
    public static boolean allowDragonBlockingEndExit;
    public static boolean allowRandomCorneredTransmitter;

    public ConfigurationHandler(File configFile) {
        config = new Configuration(configFile);
        FMLCommonHandler.instance().bus().register((Object)this);
        this.syncConfigData();
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("telepads")) {
            this.syncConfigData();
        }
    }

    private void syncConfigData() {
        allowDebugMessages = config.getBoolean("allowDebug", "settings", allowDebugMessages, "Determines whether or not dubug messages from the Telepads mod should be printed to the console.");
        allowParticleEffects = config.getBoolean("allowParticles", "settings", allowParticleEffects, "Should particle effects be spawned from the Telepad?");
        particleName = config.getString("particleType", "settings", particleName, "The type of particle that should spawn from the Telepad?");
        allowDragonBlockingEndExit = config.getBoolean("allowDragonBlockingEndExit", "settings", allowDragonBlockingEndExit, "Determines wether or not the prescence of the Enderdragon prevents a player from leaving the End trough a Telepad");
        allowRandomCorneredTransmitter = config.getBoolean("allowRandomCorneredTransmitter", "settings", allowRandomCorneredTransmitter, "Determines wether the transmitter gets placed randomly in one of four corners or will always be placed in the same corner.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        allowDebugMessages = true;
        allowParticleEffects = true;
        particleName = "portal";
        allowDragonBlockingEndExit = true;
        allowRandomCorneredTransmitter = true;
    }
}

