/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.handler;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.util.Position;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.IExtendedEntityProperties;
import net.subaraki.telepads.Telepads;
import net.subaraki.telepads.common.network.PacketSyncTelepadEntries;

public class PlayerLocations
implements IExtendedEntityProperties {
    public static final String PROP_NAME = "TelepadLocations";
    private EntityPlayer player;
    private List<TelepadEntry> entries;

    public PlayerLocations(EntityPlayer player) {
        this.player = player;
        this.entries = new ArrayList<TelepadEntry>();
    }

    public void saveNBTData(NBTTagCompound compound) {
        Telepads.printDebugMessage("Saving Telepad data");
        NBTTagList entryList = new NBTTagList();
        for (TelepadEntry entry : this.entries) {
            entryList.func_74742_a((NBTBase)entry.writeToNBT(new NBTTagCompound()));
        }
        compound.func_74782_a(PROP_NAME, (NBTBase)entryList);
    }

    public void loadNBTData(NBTTagCompound compound) {
        Telepads.printDebugMessage("Loading Telepad data");
        ArrayList<TelepadEntry> entryList = new ArrayList<TelepadEntry>();
        NBTTagList entryTagList = compound.func_150295_c(PROP_NAME, 10);
        for (int tagPos = 0; tagPos < entryTagList.func_74745_c(); ++tagPos) {
            entryList.add(new TelepadEntry(entryTagList.func_150305_b(tagPos)));
        }
        this.entries = entryList;
    }

    public void init(Entity entity, World world) {
    }

    public static PlayerLocations getProperties(EntityPlayer player) {
        return (PlayerLocations)player.getExtendedProperties(PROP_NAME);
    }

    public static PlayerLocations setProperties(EntityPlayer player) {
        player.registerExtendedProperties(PROP_NAME, (IExtendedEntityProperties)new PlayerLocations(player));
        return PlayerLocations.getProperties(player);
    }

    public static boolean hasProperties(EntityPlayer player) {
        return PlayerLocations.getProperties(player) != null;
    }

    public void copy(PlayerLocations properties) {
        this.entries = properties.entries;
    }

    public List<TelepadEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<TelepadEntry>();
        }
        return this.entries;
    }

    public void overrideEntries(List<TelepadEntry> entries) {
        this.entries = entries;
        this.sync();
    }

    public void addEntry(TelepadEntry entry) {
        this.getEntries().add(entry);
        this.sync();
    }

    public void removeEntry(TelepadEntry entry) {
        for (TelepadEntry tpe : this.getEntries()) {
            if (!tpe.position.equals((Object)entry.position) || tpe.dimensionID != entry.dimensionID) continue;
            this.getEntries().remove(tpe);
            break;
        }
        this.sync();
    }

    public void sync() {
        if (this.player instanceof EntityPlayerMP) {
            Telepads.instance.network.sendTo((IMessage)new PacketSyncTelepadEntries(this.player.func_110124_au(), this.entries), (EntityPlayerMP)this.player);
        }
    }

    public String getSuggestedEntryName() {
        String entryName = "Unknown Dimension";
        int entryIndex = 1;
        WorldProvider provider = DimensionManager.getProvider((int)this.player.field_71093_bK);
        if (provider != null) {
            entryName = provider.func_80007_l();
        }
        for (int index = 0; index < this.getEntries().size(); ++index) {
            if (this.getEntries().get((int)index).dimensionID != this.player.field_71093_bK) continue;
            ++entryIndex;
        }
        return entryName + " " + entryIndex;
    }

    public static class TelepadEntry {
        public String entryName;
        public int dimensionID;
        public Position position;
        public boolean isPowered;
        public boolean hasTransmitter;

        public TelepadEntry(ByteBuf buf) {
            this(ByteBufUtils.readUTF8String((ByteBuf)buf), buf.readInt(), new Position(buf), buf.readBoolean(), buf.readBoolean());
        }

        public TelepadEntry(NBTTagCompound tag) {
            this(tag.func_74779_i("entryName"), tag.func_74762_e("dimensionID"), new Position(tag), tag.func_74767_n("power"), tag.func_74767_n("transmitter"));
        }

        public TelepadEntry(String name, int dimension, Position pos, boolean isPowered, boolean hasTransmitter) {
            this.entryName = name;
            this.dimensionID = dimension;
            this.position = pos;
            this.isPowered = isPowered;
            this.hasTransmitter = hasTransmitter;
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74778_a("entryName", this.entryName);
            tag.func_74768_a("dimensionID", this.dimensionID);
            this.position.write(tag);
            tag.func_74757_a("power", this.isPowered);
            tag.func_74757_a("transmitter", this.hasTransmitter);
            return tag;
        }

        public void writeToByteBuf(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.entryName);
            buf.writeInt(this.dimensionID);
            this.position.write(buf);
            buf.writeBoolean(this.isPowered);
            buf.writeBoolean(this.hasTransmitter);
        }

        public String toString() {
            return "Entry Name: " + this.entryName + " DimensionID: " + this.dimensionID + " " + this.position.toString();
        }

        public Object clone() {
            return new TelepadEntry(this.entryName, this.dimensionID, this.position, this.isPowered, this.hasTransmitter);
        }

        public boolean equals(Object compared) {
            if (!(compared instanceof TelepadEntry)) {
                return false;
            }
            TelepadEntry entry = (TelepadEntry)compared;
            return this.entryName.equals(entry.entryName) && this.dimensionID == entry.dimensionID && this.position.equals((Object)entry.position);
        }

        public void setPowered(boolean flag) {
            this.isPowered = flag;
        }

        public void setTransmitter(boolean flag) {
            this.hasTransmitter = flag;
        }
    }
}

