/*
 * Decompiled with CFR 0.152.
 */
package net.subaraki.telepads.tileentity;

import java.awt.Color;
import java.util.List;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.subaraki.telepads.Telepads;
import net.subaraki.telepads.inventory.ContainerTelePad;
import scala.util.Random;

public class TileEntityTelepad
extends TileEntity {
    private String telepadname = "TelePad";
    private int dimension;
    private int colorFrame = new Color(26, 246, 172).getRGB();
    private int colorBase = new Color(243, 89, 233).getRGB();
    private int upgradeRotation = 0;
    private boolean hasDimensionUpgrade = false;
    private boolean hasRedstoneUpgrade = false;
    private boolean isPowered = false;
    private static int MAX_TIME = 60;
    public int counter = MAX_TIME;
    private boolean guiOpen;
    public boolean isStandingOnPlatform = false;

    public boolean canUpdate() {
        return true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.telepadname = tag.func_74779_i("name");
        this.dimension = tag.func_74762_e("dimension");
        this.hasDimensionUpgrade = tag.func_74767_n("upgrade_dimension");
        this.hasRedstoneUpgrade = tag.func_74767_n("upgrade_redstone");
        this.isPowered = tag.func_74767_n("is_powered");
        this.colorBase = tag.func_74762_e("colorBase");
        this.colorFrame = tag.func_74762_e("colorFrame");
        this.upgradeRotation = tag.func_74762_e("upgradeRotation");
        super.func_145839_a(tag);
    }

    public void func_145841_b(NBTTagCompound tag) {
        tag.func_74778_a("name", this.telepadname);
        tag.func_74768_a("dimension", this.dimension);
        tag.func_74757_a("upgrade_dimension", this.hasDimensionUpgrade);
        tag.func_74757_a("upgrade_redstone", this.hasRedstoneUpgrade);
        tag.func_74757_a("is_powered", this.isPowered);
        tag.func_74768_a("colorBase", this.colorBase);
        tag.func_74768_a("colorFrame", this.colorFrame);
        tag.func_74768_a("upgradeRotation", this.upgradeRotation);
        super.func_145841_b(tag);
    }

    public void func_145845_h() {
        if (this.isPowered) {
            return;
        }
        Telepads.proxy.createTelepadParticleEffect(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isStandingOnPlatform);
        if (!this.field_145850_b.field_72995_K) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((double)this.field_145851_c + 1.0), (double)((double)this.field_145848_d + 1.0), (double)((double)this.field_145849_e + 1.0));
            List playersInRange = this.field_145850_b.func_72872_a(EntityPlayer.class, aabb);
            if (this.isStandingOnPlatform) {
                if (playersInRange.isEmpty()) {
                    this.changePlatformState(false);
                    return;
                }
                if (this.counter >= 0) {
                    --this.counter;
                }
                boolean hasDragon = false;
                if (this.field_145850_b.field_73011_w.field_76574_g == 1 && this.counter < 0) {
                    for (Object o : this.field_145850_b.field_72996_f) {
                        if (!(o instanceof EntityDragon)) continue;
                        hasDragon = true;
                    }
                    if (hasDragon) {
                        for (EntityPlayer player : playersInRange) {
                            player.func_145747_a((IChatComponent)new ChatComponentText("The Ender Dragon obstructs you from going back !"));
                            this.counter = MAX_TIME;
                        }
                    } else {
                        this.activateTelepadGui(playersInRange);
                    }
                } else {
                    this.activateTelepadGui(playersInRange);
                }
            } else if (!playersInRange.isEmpty() && !this.isStandingOnPlatform) {
                this.changePlatformState(true);
            }
        }
    }

    public void resetTE() {
        this.counter = MAX_TIME;
        this.isStandingOnPlatform = false;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.guiOpen = false;
    }

    private void activateTelepadGui(List<EntityPlayer> playerInRange) {
        for (EntityPlayer player : playerInRange) {
            if (this.counter >= 0 || this.guiOpen || player.field_71070_bA instanceof ContainerTelePad) continue;
            this.guiOpen = true;
            player.openGui((Object)Telepads.instance, 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            break;
        }
    }

    public void changePlatformState(boolean state) {
        this.isStandingOnPlatform = state;
        if (!state) {
            this.resetTE();
        }
    }

    public String getTelePadName() {
        return this.telepadname;
    }

    public void setTelePadName(String name) {
        this.telepadname = name;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimensionID) {
        this.dimension = dimensionID;
    }

    public void setFrameColor(int rgb) {
        this.colorFrame = rgb;
    }

    public void setBaseColor(int rgb) {
        this.colorBase = rgb;
    }

    public int getColorFrame() {
        return this.colorFrame;
    }

    public int getColorBase() {
        return this.colorBase;
    }

    public boolean hasDimensionUpgrade() {
        return this.hasDimensionUpgrade;
    }

    public void addDimensionUpgrade(boolean allowed) {
        this.upgradeRotation = allowed ? new Random().nextInt(4) : 0;
        this.hasDimensionUpgrade = true;
    }

    public int getUpgradeRotation() {
        return this.upgradeRotation;
    }

    public boolean hasRedstoneUpgrade() {
        return this.hasRedstoneUpgrade;
    }

    public void addRedstoneUpgrade() {
        this.hasRedstoneUpgrade = true;
    }

    public void setPowered(boolean flag) {
        this.isPowered = flag;
    }

    public boolean isPowered() {
        return this.isPowered;
    }
}

